/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.lang.EqualsUtil;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NameChange;
import com.ur.lang.naming.NameChangeAspect;
import com.ur.lang.naming.NamedEntity;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.pin.AbstractPin$AjcClosure1;
import com.ur.polyscope.pin.ModifiablePin;
import com.ur.polyscope.pin.PinObserver;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.pin.IOServiceType;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public abstract class AbstractPin<V>
implements Pin<V>,
ModifiablePin {
    public static final int NUMBER_OF_OUTPUTS = 20;
    private static int[] outputSignalOptions;
    protected OutputPinAction outputPinAction = OutputPinAction.NONE;
    private String userDefinedName = "";
    private boolean userDefinedNameInvalid = true;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        AbstractPin.ajc$preClinit();
        outputSignalOptions = PrimitiveUtils.initArray((int)0, (int)20);
    }

    protected static void fireNameChangedEvent(final Pin<?> pin, final String oldName, final String newName) {
        EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

            public void notify(InstallationStateListener listener) {
                listener.installationModified();
            }
        });
        EventNotificationService.notify(PinObserver.class, (NotificationStrategy)new NotificationStrategy<PinObserver>(){

            public void notify(PinObserver listener) {
                listener.nameChanged((NamedEntity)pin, oldName, newName);
            }
        });
    }

    public static int[] getOutputSignalOptions() {
        return (int[])outputSignalOptions.clone();
    }

    public static void setOutputSignalOptions(int[] outputSignalOptions) {
        System.arraycopy(outputSignalOptions, 0, AbstractPin.outputSignalOptions, 0, outputSignalOptions.length);
    }

    public static int getOutputSignalOption(int pinId) {
        return outputSignalOptions[pinId];
    }

    protected static void fireInstallationChangedEvent() {
        EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

            public void notify(InstallationStateListener listener) {
                listener.installationModified();
            }
        });
    }

    public int getGlobalOutputPinID() {
        return this.getPin();
    }

    public boolean useDisplayNameOverDefaultName() {
        return false;
    }

    public String getName() {
        if (this.userDefinedNameInvalid) {
            return this.getDefaultName();
        }
        return this.userDefinedName;
    }

    @NameChange
    public void setName(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AbstractPin$AjcClosure1 abstractPin$AjcClosure1 = new AbstractPin$AjcClosure1(objectArray);
        NameChangeAspect.aspectOf().aroundAnnotatedMethod(abstractPin$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public boolean sameAs(NamedEntity entity) {
        return this == entity;
    }

    public String getDefinedName() {
        return this.getUserDefinedName();
    }

    public String getUserDefinedName() {
        return this.userDefinedName;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public OutputPinAction getOutputAction() {
        return this.outputPinAction;
    }

    @Override
    public void setOutputAction(OutputPinAction action) {
        this.outputPinAction = action;
    }

    public IOServiceType getValueType() {
        if (this.getValue() instanceof Byte) {
            return IOServiceType.DIGITAL;
        }
        if (this.getValue() instanceof Double) {
            return IOServiceType.ANALOG;
        }
        if (this.getValue() instanceof Integer) {
            return IOServiceType.INTEGER;
        }
        return IOServiceType.UNKNOWN;
    }

    public boolean isUnassigned() {
        if (this.isInput()) {
            return true;
        }
        return this.getOutputAction() != OutputPinAction.PROGRAM_RUNNING && this.getOutputAction() != OutputPinAction.CONTINUOUS_PULSE && this.getOutputAction() != OutputPinAction.LOW_WHEN_PROGRAM_ABORTED_HIGH_WHEN_NOT;
    }

    @Override
    public void generatePreambleScript(ScriptWriter writer) {
        if (this.getGlobalOutputPinID() >= 20) {
            Log.error((String)("An invalid pin was accessed by the IOService " + this.getClass()));
            return;
        }
        if (this.outputPinAction.getRunstateChoice() != 0) {
            writer.appendLine(this.appendSetOutputRunstateDependentChoice(this.outputPinAction.getRunstateChoice()));
        }
    }

    @Override
    public String appendSetOutputRunstateDependentChoice(int choice) {
        return "";
    }

    protected void setOutputSignalOption(int option) {
        AbstractPin.outputSignalOptions[this.getGlobalOutputPinID()] = option;
        AbstractPin.fireInstallationChangedEvent();
    }

    static final /* synthetic */ void setName_aroundBody0(AbstractPin ajc$this, String name, JoinPoint joinPoint) {
        if (!EqualsUtil.equals((Object)ajc$this.userDefinedName, (Object)name)) {
            String oldName = ajc$this.getName();
            ajc$this.userDefinedName = name;
            ajc$this.userDefinedNameInvalid = StringUtils.isNullOrOnlyWhitespace((String)ajc$this.userDefinedName);
            AbstractPin.fireNameChangedEvent(ajc$this, oldName, ajc$this.getName());
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractPin.java", AbstractPin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setName", "com.ur.polyscope.pin.AbstractPin", "java.lang.String", "name", "", "void"), 84);
    }
}

