/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.lang.Defense;
import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.pin.AbstractPin;
import com.ur.polyscope.pin.AbstractRegister$AjcClosure1;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.pin.IOServiceType;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public abstract class AbstractRegister<V>
extends AbstractPin<V>
implements Register<V> {
    private static final String SET_RUNSTATE_GP_OUTPUT_TO_VALUE = "set_runstate_gp_%s_output_to_value(%s, %s)";
    protected final int index;
    private V value;
    private final boolean isInput;
    private final String shortName;
    private Map<String, String> type2defaultName = new HashMap<String, String>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public AbstractRegister(int index, V defaultValue, boolean isInput, String shortNamePrefix) {
        this.index = index;
        this.value = defaultValue;
        this.isInput = isInput;
        this.shortName = AbstractRegister.createShortName(shortNamePrefix, index, isInput);
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    @Override
    public IOServiceType getValueType() {
        if (this.getValue() instanceof Boolean) {
            return IOServiceType.BOOLEAN;
        }
        if (this.getValue() instanceof Double) {
            return IOServiceType.FLOAT;
        }
        if (this.getValue() instanceof Integer) {
            return IOServiceType.INTEGER;
        }
        return IOServiceType.UNKNOWN;
    }

    public boolean isInput() {
        return this.isInput;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getPin() {
        return this.index;
    }

    protected String generateGetterScriptCode(String type) {
        String direction = this.isInput ? "input" : "output";
        return "read_" + direction + "_" + type + "_register(" + this.index + ")";
    }

    protected String generateSetterScriptCode(String type, String value) {
        String direction = this.isInput ? "input" : "output";
        return "write_" + direction + "_" + type + "_register(" + this.index + ", " + value + ")";
    }

    protected String getDefaultName(String type) {
        String defaultName = this.type2defaultName.get(type);
        if (defaultName == null) {
            String direction = this.isInput ? "in" : "out";
            defaultName = String.format("GP_%s_%s[%s]", type, direction, this.index);
            this.type2defaultName.put(type, defaultName);
        }
        return defaultName;
    }

    private static String createShortName(String prefix, int index, boolean isInput) {
        StringBuilder sb = new StringBuilder();
        sb.append("GP");
        sb.append(prefix);
        sb.append(isInput ? (char)'i' : 'o');
        sb.append('[');
        sb.append(index);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public OutputPinAction getOutputAction() {
        return this.outputPinAction;
    }

    @Override
    @InstallationChangedEvent
    public void setOutputAction(OutputPinAction action) {
        OutputPinAction outputPinAction = action;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)((Object)outputPinAction));
        Object[] objectArray = new Object[]{this, outputPinAction, joinPoint};
        AbstractRegister$AjcClosure1 abstractRegister$AjcClosure1 = new AbstractRegister$AjcClosure1(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(abstractRegister$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    public String generateRunstateDependentChoice() {
        return this.outputPinAction.getRunstateChoice() == 0 ? "" : this.appendSetOutputRunstateDependentChoice(this.outputPinAction.getRunstateChoice());
    }

    @Override
    public int getModificationChoice() {
        return 0;
    }

    @Override
    public void setModificationChoice(int choice) {
    }

    @Override
    public boolean isProgramStateModeSupported() {
        return true;
    }

    @Override
    public void generatePreambleScript(ScriptWriter writer) {
        if (this.getOutputAction() != OutputPinAction.NONE) {
            writer.appendLine(this.generateRunstateDependentChoice());
        }
    }

    protected String appendSetOutputRunstateDependentChoice(String type, int choice) {
        Defense.isCondition((!this.isInput ? 1 : 0) != 0, (String)"OutputRunstateDependent choice called on Input type register");
        return String.format(SET_RUNSTATE_GP_OUTPUT_TO_VALUE, type, this.index, choice);
    }

    static {
        AbstractRegister.ajc$preClinit();
    }

    static final /* synthetic */ void setOutputAction_aroundBody0(AbstractRegister ajc$this, OutputPinAction action, JoinPoint joinPoint) {
        ajc$this.outputPinAction = action;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractRegister.java", AbstractRegister.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setOutputAction", "com.ur.polyscope.pin.AbstractRegister", "com.ur.polyscope.pin.actions.OutputPinAction", "action", "", "void"), 108);
    }
}

