/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.monitor.RobotState;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.io.tool.ToolIOSettings;
import com.ur.polyscope.pin.AbstractPin;
import com.ur.polyscope.pin.ResolvablePin;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.CollectionUtils;
import javax.inject.Inject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class AnalogIOPin
extends AbstractPin<Double>
implements ResolvablePin {
    public static final int MAX_VOLTAGE = 10;
    public static final int MIN_VOLTAGE = 0;
    public static final int MAX_MILLIAMPS = 20;
    public static final int MIN_MILLIAMPS = 4;
    public static final String DEFAULT_INPUT_NAME = "analog_in";
    public static final String DEFAULT_OUTPUT_NAME = "analog_out";
    private static final int OUTPUT_PIN_OFFSET = 10;
    private boolean isInput;
    private int pin;
    private transient InstallationComponentLookup installationProvider;

    @Override
    public int getGlobalOutputPinID() {
        return this.pin + 10;
    }

    @Inject
    protected AnalogIOPin(InstallationComponentLookup provider) {
        this.installationProvider = provider;
    }

    public AnalogIOPin(boolean isInput, int pin, InstallationComponentLookup provider) {
        this.isInput = isInput;
        this.pin = pin;
        this.installationProvider = provider;
    }

    public Double getValue() {
        if (this.isInput) {
            return RobotState.getLatestRobotState().analogIn[this.pin];
        }
        return RobotState.getLatestRobotState().analogOut[this.pin];
    }

    public String getDefaultName() {
        if (this.isInput) {
            return "analog_in[" + this.pin + "]";
        }
        return "analog_out[" + this.pin + "]";
    }

    public String getShortName() {
        if (this.isInput) {
            return "AI[" + this.pin + "]";
        }
        return "AO[" + this.pin + "]";
    }

    public int getAnalogInputRange() {
        if (this.isInput && this.pin < 4) {
            return this.getIOService().getAnalogInputRange(this.pin);
        }
        return 0;
    }

    private IOService getIOService() {
        return (IOService)this.installationProvider.getComponent(IOService.class);
    }

    public int getAnalogOutputDomain() {
        if (!this.isInput && this.pin < 2) {
            int analogOutputDomain = this.getIOService().getAnalogOutputDomain(this.pin);
            if (analogOutputDomain < 0) {
                analogOutputDomain = 0;
            }
            return analogOutputDomain;
        }
        return 0;
    }

    public boolean isInput() {
        return this.isInput;
    }

    public int getPin() {
        return this.pin;
    }

    @Override
    public int getModificationChoice() {
        if (this.isInput()) {
            return 0;
        }
        return AnalogIOPin.getOutputSignalOption(this.getGlobalOutputPinID());
    }

    @Override
    public void setModificationChoice(int choice) {
        if (!this.isInput()) {
            this.setOutputSignalOption(choice);
        }
    }

    @Override
    public String generateRunstateDependentChoice() {
        return this.getIOService().appendSetRunstateOutputs(new ScriptWriter()) + this.appendSetOutputRunstateDependentChoice(this.outputPinAction.getRunstateChoice());
    }

    @Override
    public boolean isProgramStateModeSupported() {
        return true;
    }

    public boolean isAssignedForToolComm() {
        return CollectionUtils.filter((Object[])new AnalogIOPin[]{this}, ((IOService)this.installationProvider.getComponent(IOService.class)).getToolCommEnabledPredicate(((ToolIOSettings)this.installationProvider.getComponent(ToolIOSettings.class)).getToolCommInfo().isEnabled())).isEmpty();
    }

    public String generateGetterScriptCode() {
        if (this.pin > 1) {
            if (this.isInput()) {
                return "get_tool_analog_in(" + (this.pin - 2) + ")";
            }
            return "get_tool_analog_out(" + (this.pin - 2) + ")";
        }
        if (this.isInput()) {
            return "get_standard_analog_in(" + this.pin + ")";
        }
        return "get_standard_analog_out(" + this.pin + ")";
    }

    public String generateSetterScriptCode(String value) {
        if (this.pin > 1) {
            if (this.isInput()) {
                return "set_tool_analog_in(" + (this.pin - 2) + ", " + value + ")";
            }
            return "set_tool_analog_out(" + (this.pin - 2) + ", " + value + ")";
        }
        if (this.isInput()) {
            return "set_standard_analog_in(" + this.pin + ", " + value + ")";
        }
        return "set_standard_analog_out(" + this.pin + ", " + value + ")";
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.isInput).append(this.pin).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !AnalogIOPin.class.equals(obj.getClass())) {
            return false;
        }
        AnalogIOPin other = (AnalogIOPin)obj;
        return new EqualsBuilder().append(this.isInput, other.isInput).append(this.pin, other.pin).isEquals();
    }

    @Override
    public String appendSetOutputRunstateDependentChoice(int choice) {
        return "set_runstate_standard_analog_output_to_value(" + this.getPin() + ", " + choice + ")";
    }

    @Override
    public boolean isResolvable() {
        return !this.isInput() || !this.isAssignedForToolComm();
    }
}

