/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.monitor.RobotState;
import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.pin.AbstractPin;
import com.ur.polyscope.pin.ConfigurableIOPin$AjcClosure1;
import com.ur.polyscope.pin.ConfigurableName;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import javax.inject.Inject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ConfigurableIOPin
extends AbstractPin<Byte>
implements InputActionPin {
    public static final String DEFAULT_INPUT_NAME = "config_in";
    public static final String DEFAULT_OUTPUT_NAME = "config_out";
    private static final int PIN_OFFSET = 12;
    private boolean isInput;
    private int pin;
    private final transient ConfigurableName provider;
    private final transient InstallationComponentLookup lookupService;
    private PinAction action = DefaultInputPinAction.INPUT_PIN_ACTION_NONE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    protected ConfigurableIOPin(ConfigurableName provider, InstallationComponentLookup lookupService) {
        this.provider = provider;
        this.lookupService = lookupService;
    }

    public ConfigurableIOPin(boolean isInput, int pin, ConfigurableName provider, InstallationComponentLookup lookupService) {
        this.isInput = isInput;
        this.pin = pin;
        this.provider = provider;
        this.lookupService = lookupService;
    }

    @Override
    public int getGlobalOutputPinID() {
        return this.pin + 12;
    }

    public Byte getValue() {
        if (this.isInput) {
            return RobotState.getLatestRobotState().configurableIn[this.pin];
        }
        return RobotState.getLatestRobotState().configurableOut[this.pin];
    }

    public String getDefaultName() {
        if (this.isInput) {
            return "config_in[" + this.pin + "]";
        }
        return "config_out[" + this.pin + "]";
    }

    public String getShortName() {
        if (this.isInput) {
            return "CI[" + this.pin + "]";
        }
        return "CO[" + this.pin + "]";
    }

    public int getPin() {
        return this.pin;
    }

    public boolean isInput() {
        return this.isInput;
    }

    @Override
    public String getDefinedName() {
        return this.isUnassigned() ? super.getUserDefinedName() : this.getShortFunctionName();
    }

    @Override
    public int getModificationChoice() {
        if (this.isInput()) {
            return 0;
        }
        return AbstractPin.getOutputSignalOption(this.getGlobalOutputPinID());
    }

    @Override
    public void setModificationChoice(int choice) {
        if (!this.isInput()) {
            this.setOutputSignalOption(choice);
        }
    }

    public String getFunctionName() {
        return this.isSafetyOutputPin() ? this.provider.getFunctionName(this) : this.getOutputAction().getShortFunctionName();
    }

    public String getShortFunctionName() {
        return this.isSafetyOutputPin() ? this.provider.getShortFunctionName(this) : this.getOutputAction().getShortFunctionName();
    }

    @Override
    public boolean isUnassigned() {
        if (this.provider.isNamed(this)) {
            return false;
        }
        return super.isUnassigned();
    }

    public boolean isSafetyOutputPin() {
        return this.provider.isNamed(this);
    }

    @Override
    public String generateRunstateDependentChoice() {
        return this.getIOService().appendSetRunstateOutputs(new ScriptWriter()) + this.appendSetOutputRunstateDependentChoice(this.outputPinAction.getRunstateChoice());
    }

    @Override
    public boolean isProgramStateModeSupported() {
        return true;
    }

    private IOService getIOService() {
        return (IOService)this.lookupService.getComponent(IOService.class);
    }

    public String generateGetterScriptCode() {
        if (this.isInput()) {
            return "get_configurable_digital_in(" + this.pin + ")";
        }
        return "get_configurable_digital_out(" + this.pin + ")";
    }

    public String generateSetterScriptCode(String value) {
        if (this.isInput()) {
            return "set_configurable_digital_in(" + this.pin + ", " + value + ")";
        }
        return "set_configurable_digital_out(" + this.pin + ", " + value + ")";
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.isInput).append(this.pin).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !ConfigurableIOPin.class.equals(obj.getClass())) {
            return false;
        }
        ConfigurableIOPin other = (ConfigurableIOPin)obj;
        return new EqualsBuilder().append(this.isInput, other.isInput).append(this.pin, other.pin).isEquals();
    }

    @Override
    public PinAction getIOPinAction() {
        return this.action;
    }

    @Override
    @InstallationChangedEvent
    public void setIOPinAction(PinAction action) {
        PinAction pinAction = action;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)pinAction);
        Object[] objectArray = new Object[]{this, pinAction, joinPoint};
        ConfigurableIOPin$AjcClosure1 configurableIOPin$AjcClosure1 = new ConfigurableIOPin$AjcClosure1(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(configurableIOPin$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    public String generateInputActionScriptCode() {
        if (this.isInput()) {
            boolean isFreeDrive = this.getIOPinAction() instanceof DefaultInputPinAction && ((DefaultInputPinAction)this.getIOPinAction()).getInputPinAction() == InputPinAction.FREEDRIVE;
            return "set_configurable_digital_input_action(" + this.pin + ", " + (isFreeDrive ? "\"freedrive\"" : "\"default\"") + ")";
        }
        return "";
    }

    @Override
    public String appendSetOutputRunstateDependentChoice(int choice) {
        return "set_runstate_configurable_digital_output_to_value(" + this.getPin() + ", " + choice + ")";
    }

    static {
        ConfigurableIOPin.ajc$preClinit();
    }

    static final /* synthetic */ void setIOPinAction_aroundBody0(ConfigurableIOPin ajc$this, PinAction action, JoinPoint joinPoint) {
        ajc$this.action = action;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConfigurableIOPin.java", ConfigurableIOPin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setIOPinAction", "com.ur.polyscope.pin.ConfigurableIOPin", "com.ur.polyscope.pin.PinAction", "action", "", "void"), 184);
    }
}

