/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.pin.ActionFilter;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.security.accessmode.AccessMode;
import com.ur.polyscope.security.accessmode.AccessModeService;

class FilterMovementIO
implements ActionFilter {
    private final AccessModeService accessModeService;

    public FilterMovementIO(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    @Override
    public boolean filter(PinAction action) {
        return this.isControlModeLocal() && this.filterIfOneOf(action, InputPinAction.PAUSE, InputPinAction.STOP);
    }

    private boolean isControlModeLocal() {
        return AccessMode.isLocal((AccessMode)this.accessModeService.getAccessMode());
    }

    private boolean filterIfOneOf(PinAction action, InputPinAction ... options) {
        if (action instanceof DefaultInputPinAction) {
            return EqualsUtil.notEqualsOneOf((Object)((Object)((DefaultInputPinAction)action).getInputPinAction()), (Object[])options);
        }
        return true;
    }
}

