/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.polyscope.pin.ActionFilter;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.FilterMovementIO;
import com.ur.polyscope.pin.GeneralPurposeRegisterListener;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.PinValueChangeObserver;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.security.accessmode.AccessModeService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class IOActionService
implements RobotStateListener,
GeneralPurposeRegisterListener.Boolean,
PinValueChangeObserver.Digital {
    private final IOService ioService;
    private byte[] standardBefore = null;
    private byte[] standardBeforeSimulated = null;
    private byte[] toolBefore = null;
    private byte[] toolBeforeSimulated = null;
    private byte[] configurableBefore = null;
    private byte[] configurableBeforeSimulated = null;
    private byte[] booleanRegistersBefore = null;
    private byte[] booleanRegistersBeforeSimulated = null;
    private final Map<Pin<?>, PinValueChangeObserver.Digital.Value> previousDigitalInputs;
    private final List<ActionFilter> filters = new CopyOnWriteArrayList<ActionFilter>();

    @Inject
    IOActionService(IOService ioService, AccessModeService controlModeService) {
        this.ioService = ioService;
        this.previousDigitalInputs = new ConcurrentHashMap(200);
        EventNotificationService.register((Object)this, PinValueChangeObserver.Digital.class, (Object)this);
        this.filters.add(new FilterOnEmptyOrNull());
        this.filters.add(new FilterMovementIO(controlModeService));
    }

    @Deprecated
    public void updateRobotState(RobotState robotState) {
        byte[] standardNow = robotState.digitalIn;
        byte[] toolNow = robotState.toolIn;
        byte[] configurableNow = robotState.configurableIn;
        if (robotState.real) {
            this.updateRealRobot(standardNow, toolNow, configurableNow);
        } else {
            this.updateSimulatedRobot(standardNow, toolNow, configurableNow);
        }
    }

    private void updateRealRobot(byte[] standardNow, byte[] toolNow, byte[] configurableNow) {
        this.performActionOnChangeOrInitialization(this.ioService.getStandardDigitalInputPins(), this.standardBefore, standardNow);
        this.performActionOnChangeOrInitialization(this.ioService.getToolDigitalInputPins(), this.toolBefore, toolNow);
        this.performActionOnChangeOrInitialization(this.ioService.getConfigurableDigitalInputPins(), this.configurableBefore, configurableNow);
        this.standardBefore = (byte[])standardNow.clone();
        this.toolBefore = (byte[])toolNow.clone();
        this.configurableBefore = (byte[])configurableNow.clone();
    }

    private void updateSimulatedRobot(byte[] standardNow, byte[] toolNow, byte[] configurableNow) {
        this.performActionOnChangeOrInitialization(this.ioService.getStandardDigitalInputPins(), this.standardBeforeSimulated, standardNow);
        this.performActionOnChangeOrInitialization(this.ioService.getToolDigitalInputPins(), this.toolBeforeSimulated, toolNow);
        this.performActionOnChangeOrInitialization(this.ioService.getConfigurableDigitalInputPins(), this.configurableBeforeSimulated, configurableNow);
        this.standardBeforeSimulated = (byte[])standardNow.clone();
        this.toolBeforeSimulated = (byte[])toolNow.clone();
        this.configurableBeforeSimulated = (byte[])configurableNow.clone();
    }

    @Override
    public void digitalInputChanged(Map<Pin<?>, PinValueChangeObserver.Digital.Value> newPinValues) {
        for (Map.Entry<Pin<?>, PinValueChangeObserver.Digital.Value> now : newPinValues.entrySet()) {
            PinValueChangeObserver.Digital.Value before = this.previousDigitalInputs.get(now.getKey());
            if (!now.getValue().hasChangedBetweenDefinedStates(before)) continue;
            Log.debug((String)(" oldvalue = " + (Object)((Object)before) + " newvalue = " + (Object)((Object)now.getValue())));
            this.performActionForPin(now.getKey(), now.getValue() == PinValueChangeObserver.Digital.Value.HIGH);
        }
        this.previousDigitalInputs.putAll(newPinValues);
    }

    private void performActionOnChangeOrInitialization(Pin<?>[] pins, byte[] lastConfiguration, byte[] currentConfiguration) {
        if (lastConfiguration != null) {
            this.performActionsOnChange(pins, lastConfiguration, currentConfiguration);
        } else {
            this.performActionsOnChange(pins, IOActionService.invert(currentConfiguration), currentConfiguration);
        }
    }

    private static byte[] invert(byte[] now) {
        byte[] result = new byte[now.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (byte)(now[i] == 0 ? 1 : 0);
            ++i;
        }
        return result;
    }

    @Override
    public void updateBooleanRegisters(boolean[] inputRegisters, boolean[] outputRegisters) {
        byte[] booleanRegistersNow = new byte[inputRegisters.length];
        int i = 0;
        while (i < inputRegisters.length) {
            booleanRegistersNow[i] = (byte)(inputRegisters[i] ? 1 : 0);
            ++i;
        }
        if (RobotState.getLatestRobotState().real) {
            if (this.booleanRegistersBefore != null) {
                this.performActionsOnChange(this.ioService.getGeneralPurposeBooleanInputRegisters(), this.booleanRegistersBefore, booleanRegistersNow);
            }
            this.booleanRegistersBefore = (byte[])booleanRegistersNow.clone();
        } else {
            if (this.booleanRegistersBeforeSimulated != null) {
                this.performActionsOnChange(this.ioService.getGeneralPurposeBooleanInputRegisters(), this.booleanRegistersBeforeSimulated, booleanRegistersNow);
            }
            this.booleanRegistersBeforeSimulated = (byte[])booleanRegistersNow.clone();
        }
    }

    private void performActionsOnChange(Pin<?>[] pins, byte[] before, byte[] now) {
        int length = Math.min(Math.min(before.length, now.length), pins.length);
        int i = 0;
        while (i < length) {
            if (this.different(before[i], now[i])) {
                this.performActionForPin(pins[i], now[i] != 0);
            }
            ++i;
        }
    }

    private void performActionForPin(Pin<?> pin, boolean on) {
        PinAction action;
        if (pin instanceof InputActionPin && !this.filter(action = ((InputActionPin)pin).getIOPinAction())) {
            if (on) {
                action.onPress();
            } else {
                action.onRelease();
            }
        }
    }

    private boolean filter(PinAction action) {
        for (ActionFilter actionFilter : this.filters) {
            if (!actionFilter.filter(action)) continue;
            return true;
        }
        return false;
    }

    private boolean different(byte b, byte c) {
        return b != c;
    }

    private static class FilterOnEmptyOrNull
    implements ActionFilter {
        private FilterOnEmptyOrNull() {
        }

        @Override
        public boolean filter(PinAction action) {
            return action == null || action == DefaultInputPinAction.INPUT_PIN_ACTION_NONE;
        }
    }
}

