/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.pin.IOAvailabilityChange;
import com.ur.polyscope.pin.service.IOInterface;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.util.event.EventNotificationService;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class IOPinLookup {
    private final Map<String, Pin<?>> lookupMap = new HashMap();
    private final List<Pin<?>> sortedList = new LinkedList();
    private boolean dirty = true;
    private final Object syncObject = new Object();
    protected final IOService ioService;
    protected final InstallationComponentLookup lookupService;
    protected final Set<IOInterface> ioInterfaces;

    public IOPinLookup(IOService ioService, InstallationComponentLookup lookupService, Set<IOInterface> ioInterfaces) {
        this.ioService = ioService;
        this.lookupService = lookupService;
        this.ioInterfaces = ioInterfaces;
        EventNotificationService.register((Object)this, InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            private void markDirty() {
                IOPinLookup.this.dirty = true;
            }

            public void installationModified() {
                this.markDirty();
            }

            public void installationLoaded(Installation installation) {
                this.markDirty();
            }
        });
        EventNotificationService.register((Object)this, IOAvailabilityChange.class, (Object)new IOAvailabilityChange(){

            @Override
            public void requestUpdateIOAvailability() {
                IOPinLookup.this.dirty = true;
            }
        });
    }

    public Pin<?> getPinByName(String defaultName) {
        return this.getLookupMap().get(defaultName);
    }

    public List<Pin<?>> getPinList() {
        return this.getSortedList();
    }

    protected void addPins(Pin<?>[] pins) {
        this.addPins(Arrays.asList(pins));
    }

    protected void addPins(Collection<? extends Pin<?>> pins) {
        for (Pin<?> each : pins) {
            this.lookupMap.put(each.getName(), each);
            this.lookupMap.put(each.getDefaultName(), each);
            this.sortedList.add(each);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Pin<?>> getLookupMap() {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.dirty) {
                this.rebuildAll();
            }
        }
        return this.lookupMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pin<?>> getSortedList() {
        LinkedList result;
        Object object = this.syncObject;
        synchronized (object) {
            if (this.dirty) {
                this.rebuildAll();
            }
            result = new LinkedList(this.sortedList);
        }
        return result;
    }

    private void rebuildAll() {
        this.lookupMap.clear();
        this.sortedList.clear();
        this.rebuild();
        this.dirty = false;
    }

    protected abstract void rebuild();
}

