/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.pin.IOPinLookup;
import com.ur.polyscope.pin.service.IOInterface;
import com.ur.polyscope.pin.service.IOService;
import java.util.Set;

public class InputPinLookup
extends IOPinLookup {
    public InputPinLookup(IOService ioService, InstallationComponentLookup lookupService, Set<IOInterface> ioInterfaces) {
        super(ioService, lookupService, ioInterfaces);
    }

    @Override
    protected void rebuild() {
        this.addPins(this.ioService.getStandardDigitalInputPins());
        this.addPins(this.ioService.getToolDigitalInputPins());
        this.addPins(this.ioService.getConfigurableDigitalInputPins());
        this.addPins(this.ioService.getAllAnalogInputPins());
        if (this.lookupService.hasInstallation()) {
            for (IOInterface each : this.ioInterfaces) {
                this.addPins(each.getInputs(IOService.IOInterfaceType.MODBUS, IOService.IOSignalType.ALL));
            }
            for (IOInterface each : this.ioInterfaces) {
                this.addPins(each.getInputs(IOService.IOInterfaceType.IMMI, IOService.IOSignalType.ALL));
            }
        }
        this.addPins(this.ioService.getCustomDigitalInputPins());
        this.addPins(this.ioService.getCustomAnalogInputPins());
        this.addPins(this.ioService.getCustomIntegerInputPins());
        this.addPins(this.ioService.getGeneralPurposeBooleanInputRegisters());
        this.addPins(this.ioService.getGeneralPurposeIntInputRegisters());
        this.addPins(this.ioService.getGeneralPurposeFloatInputRegisters());
    }
}

