/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.pin.IOPinLookup;
import com.ur.polyscope.pin.service.IOInterface;
import com.ur.polyscope.pin.service.IOService;
import java.util.Set;

public class OutputPinLookup
extends IOPinLookup {
    public OutputPinLookup(IOService ioService, InstallationComponentLookup lookupService, Set<IOInterface> ioInterfaces) {
        super(ioService, lookupService, ioInterfaces);
    }

    @Override
    protected void rebuild() {
        this.addPins(this.ioService.getStandardDigitalOutputPins());
        this.addPins(this.ioService.getToolDigitalOutputPins());
        this.addPins(this.ioService.getConfigurableDigitalOutputPins());
        this.addPins(this.ioService.getStandardAnalogOutputPins());
        if (this.lookupService.hasInstallation()) {
            for (IOInterface each : this.ioInterfaces) {
                this.addPins(each.getOutputs(IOService.IOInterfaceType.MODBUS, IOService.IOSignalType.ALL));
            }
            for (IOInterface each : this.ioInterfaces) {
                this.addPins(each.getOutputs(IOService.IOInterfaceType.IMMI, IOService.IOSignalType.ALL));
            }
        }
        this.addPins(this.ioService.getCustomDigitalOutputPins());
        this.addPins(this.ioService.getCustomAnalogOutputPins());
        this.addPins(this.ioService.getCustomIntegerOutputPins());
        this.addPins(this.ioService.getGeneralPurposeBooleanOutputRegisters());
        this.addPins(this.ioService.getGeneralPurposeIntOutputRegisters());
        this.addPins(this.ioService.getGeneralPurposeFloatOutputRegisters());
    }
}

