/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.polyscope.pin.PinObserver;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.reference.Reference;
import com.ur.reference.ReferenceHandlingStrategyImpl;
import com.ur.util.event.EventNotificationService;
import javax.inject.Inject;

public class PinReferenceHandlingStrategy
extends ReferenceHandlingStrategyImpl<String, Pin<?>, PinReference> {
    private final IOService ioService;

    @Inject
    public PinReferenceHandlingStrategy(IOService ioService) {
        this.ioService = ioService;
        EventNotificationService.register((Object)((Object)this), PinObserver.class, (Object)new PinOwnerUpdater());
    }

    protected PinReference createReference(String key) {
        return new PinReference(key, this.ioService);
    }

    protected String getKeyFor(Pin<?> target) {
        return target.getDefaultName();
    }

    private final class PinOwnerUpdater
    implements PinObserver {
        private PinOwnerUpdater() {
        }

        public void nameChanged(Pin<?> pin, String oldName, String newName) {
            PinReferenceHandlingStrategy.this.keyChange(oldName, newName);
        }

        @Override
        public void typeChanged(Pin<?> pin) {
            PinReferenceHandlingStrategy.this.referenceChange((Reference)((PinReference)PinReferenceHandlingStrategy.this.getReferenceTo(pin)));
        }

        @Override
        public void added(Pin<?> pin) {
            PinReferenceHandlingStrategy.this.referenceChange((Reference)((PinReference)PinReferenceHandlingStrategy.this.getReferenceTo(pin)));
        }

        @Override
        public void removed(Pin<?> pin) {
            PinReferenceHandlingStrategy.this.referenceChange((Reference)((PinReference)PinReferenceHandlingStrategy.this.getReferenceTo(pin)));
        }
    }
}

