/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.monitor.RobotState;
import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.pin.AbstractPin;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.StandardIOPin$AjcClosure1;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class StandardIOPin
extends AbstractPin<Byte>
implements InputActionPin {
    public static final String DEFAULT_INPUT_NAME = "digital_in";
    public static final String DEFAULT_OUTPUT_NAME = "digital_out";
    private IOService ioService;
    private boolean isInput;
    private int pin;
    private PinAction action = DefaultInputPinAction.INPUT_PIN_ACTION_NONE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public StandardIOPin(boolean isInput, int pin, IOService ioService) {
        this.isInput = isInput;
        this.pin = pin;
        this.ioService = ioService;
    }

    public Byte getValue() {
        if (this.isInput()) {
            return RobotState.getLatestRobotState().digitalIn[this.pin];
        }
        return RobotState.getLatestRobotState().digitalOut[this.pin];
    }

    public String getDefaultName() {
        if (this.isInput) {
            return "digital_in[" + this.pin + "]";
        }
        return "digital_out[" + this.pin + "]";
    }

    public int getPin() {
        return this.pin;
    }

    public String getShortName() {
        if (this.isInput) {
            return "DI[" + this.pin + "]";
        }
        return "DO[" + this.pin + "]";
    }

    public boolean isInput() {
        return this.isInput;
    }

    @Override
    public int getModificationChoice() {
        if (this.isInput()) {
            return 0;
        }
        return AbstractPin.getOutputSignalOption(this.getPin());
    }

    @Override
    public void setModificationChoice(int choice) {
        if (!this.isInput()) {
            this.setOutputSignalOption(choice);
        }
    }

    @Override
    public String generateRunstateDependentChoice() {
        return this.ioService.appendSetRunstateOutputs(new ScriptWriter()) + this.appendSetOutputRunstateDependentChoice(this.outputPinAction.getRunstateChoice());
    }

    @Override
    public boolean isProgramStateModeSupported() {
        return true;
    }

    public String generateGetterScriptCode() {
        if (this.isInput()) {
            return "get_standard_digital_in(" + this.pin + ")";
        }
        return "get_standard_digital_out(" + this.pin + ")";
    }

    public String generateSetterScriptCode(String value) {
        if (this.isInput()) {
            return "set_standard_digital_in(" + this.pin + ", " + value + ")";
        }
        return "set_standard_digital_out(" + this.pin + ", " + value + ")";
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.isInput).append(this.pin).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !StandardIOPin.class.equals(obj.getClass())) {
            return false;
        }
        StandardIOPin other = (StandardIOPin)obj;
        return new EqualsBuilder().append(this.isInput, other.isInput).append(this.pin, other.pin).isEquals();
    }

    @Override
    public PinAction getIOPinAction() {
        return this.action;
    }

    @Override
    @InstallationChangedEvent
    public void setIOPinAction(PinAction action) {
        PinAction pinAction = action;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)pinAction);
        Object[] objectArray = new Object[]{this, pinAction, joinPoint};
        StandardIOPin$AjcClosure1 standardIOPin$AjcClosure1 = new StandardIOPin$AjcClosure1(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(standardIOPin$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    public String generateInputActionScriptCode() {
        if (this.isInput()) {
            boolean isFreeDrive = this.getIOPinAction() instanceof DefaultInputPinAction && ((DefaultInputPinAction)this.getIOPinAction()).getInputPinAction() == InputPinAction.FREEDRIVE;
            return "set_standard_digital_input_action(" + this.pin + ", " + (isFreeDrive ? "\"freedrive\"" : "\"default\"") + ")";
        }
        return "";
    }

    @Override
    public String appendSetOutputRunstateDependentChoice(int choice) {
        return "set_runstate_standard_digital_output_to_value(" + this.getPin() + ", " + choice + ")";
    }

    static {
        StandardIOPin.ajc$preClinit();
    }

    static final /* synthetic */ void setIOPinAction_aroundBody0(StandardIOPin ajc$this, PinAction action, JoinPoint joinPoint) {
        ajc$this.action = action;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StandardIOPin.java", StandardIOPin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setIOPinAction", "com.ur.polyscope.pin.StandardIOPin", "com.ur.polyscope.pin.PinAction", "action", "", "void"), 135);
    }
}

