/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin;

import com.ur.monitor.RobotState;
import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.pin.AbstractPin;
import com.ur.polyscope.pin.ConfigurableIOPin;
import com.ur.polyscope.pin.ConfigurableName;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.ProxyConfigurationIOPin;
import com.ur.polyscope.pin.ResolvablePin;
import com.ur.polyscope.pin.ToolIOPin$AjcClosure1;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.pin.service.ToolIOPinService;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import javax.inject.Inject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ToolIOPin
extends AbstractPin<Byte>
implements InputActionPin,
ResolvablePin {
    public static final String DEFAULT_INPUT_NAME = "tool_in";
    public static final String DEFAULT_OUTPUT_NAME = "tool_out";
    private static final int OUTPUT_PIN_OFFSET = 8;
    private final ToolIOPinService toolIOPinService;
    private final ConfigurableName configurableNameProvider;
    private transient InstallationComponentLookup lookupService;
    private boolean isInput;
    private int pin;
    private PinAction action = DefaultInputPinAction.INPUT_PIN_ACTION_NONE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    protected ToolIOPin(ConfigurableName configurableNameProvider, InstallationComponentLookup lookupService, ToolIOPinService toolIOPinService) {
        this.configurableNameProvider = configurableNameProvider;
        this.lookupService = lookupService;
        this.toolIOPinService = toolIOPinService;
    }

    public ToolIOPin(boolean isInput, int pin, ConfigurableName configurableNameProvider, InstallationComponentLookup lookupService, ToolIOPinService toolIOPinService) {
        this.isInput = isInput;
        this.pin = pin;
        this.configurableNameProvider = configurableNameProvider;
        this.lookupService = lookupService;
        this.toolIOPinService = toolIOPinService;
    }

    @Override
    public int getGlobalOutputPinID() {
        return this.pin + 8;
    }

    @Override
    public boolean isUnassigned() {
        if (this.isSafetyInputPin()) {
            return false;
        }
        if (this.isInput()) {
            return super.isUnassigned();
        }
        return super.isUnassigned() && !this.isPoweredPin();
    }

    @Override
    public OutputPinAction getOutputAction() {
        if (this.isPoweredPin()) {
            return OutputPinAction.getPoweredPinAction(this.pin);
        }
        return super.getOutputAction();
    }

    public boolean isPoweredPin() {
        return !this.isInput() && this.toolIOPinService.isPoweredPin();
    }

    public Byte getValue() {
        if (this.isInput()) {
            return RobotState.getLatestRobotState().toolIn[this.pin];
        }
        return RobotState.getLatestRobotState().toolOut[this.pin];
    }

    public String getDefaultName() {
        if (this.isInput) {
            return "tool_in[" + this.pin + "]";
        }
        return "tool_out[" + this.pin + "]";
    }

    public String getShortName() {
        if (this.isInput()) {
            return "TI[" + this.pin + "]";
        }
        return "TO[" + this.pin + "]";
    }

    public boolean isInput() {
        return this.isInput;
    }

    public int getPin() {
        return this.pin;
    }

    @Override
    public int getModificationChoice() {
        if (this.isInput()) {
            return 0;
        }
        return ToolIOPin.getOutputSignalOptions()[this.getGlobalOutputPinID()];
    }

    @Override
    public void setModificationChoice(int choice) {
        if (!this.isInput()) {
            this.setOutputSignalOption(choice);
        }
    }

    private IOService getIOService() {
        return (IOService)this.lookupService.getComponent(IOService.class);
    }

    @Override
    public String generateRunstateDependentChoice() {
        return this.getIOService().appendSetRunstateOutputs(new ScriptWriter()) + this.appendSetOutputRunstateDependentChoice(this.outputPinAction.getRunstateChoice());
    }

    @Override
    public boolean isProgramStateModeSupported() {
        return true;
    }

    public String generateGetterScriptCode() {
        if (this.isInput()) {
            return "get_tool_digital_in(" + this.pin + ")";
        }
        return "get_tool_digital_out(" + this.pin + ")";
    }

    public String generateSetterScriptCode(String value) {
        if (this.isInput()) {
            return "set_tool_digital_in(" + this.pin + ", " + value + ")";
        }
        return "set_tool_digital_out(" + this.pin + ", " + value + ")";
    }

    @Override
    public PinAction getIOPinAction() {
        return this.action;
    }

    @Override
    @InstallationChangedEvent
    public void setIOPinAction(PinAction action) {
        PinAction pinAction = action;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)pinAction);
        Object[] objectArray = new Object[]{this, pinAction, joinPoint};
        ToolIOPin$AjcClosure1 toolIOPin$AjcClosure1 = new ToolIOPin$AjcClosure1(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(toolIOPin$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.isInput).append(this.pin).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !ToolIOPin.class.equals(obj.getClass())) {
            return false;
        }
        ToolIOPin other = (ToolIOPin)obj;
        return new EqualsBuilder().append(this.isInput, other.isInput).append(this.pin, other.pin).isEquals();
    }

    @Override
    public String generateInputActionScriptCode() {
        if (this.isInput()) {
            boolean isFreeDrive = this.getIOPinAction() instanceof DefaultInputPinAction && ((DefaultInputPinAction)this.getIOPinAction()).getInputPinAction() == InputPinAction.FREEDRIVE;
            return "set_tool_digital_input_action(" + this.pin + ", " + (isFreeDrive ? "\"freedrive\"" : "\"default\"") + ")";
        }
        return "";
    }

    @Override
    public String appendSetOutputRunstateDependentChoice(int choice) {
        return "set_runstate_tool_digital_output_to_value(" + this.getPin() + ", " + choice + ")";
    }

    @Override
    public String getDefinedName() {
        return this.isPoweredPin() ? this.getShortFunctionName() : super.getDefinedName();
    }

    @Override
    public boolean isResolvable() {
        return this.isInput() || !this.isPoweredPin();
    }

    public boolean isSafetyInputPin() {
        return this.configurableNameProvider.isNamed(this.getProxyIOPin());
    }

    public String getFunctionName() {
        return this.isSafetyInputPin() ? this.configurableNameProvider.getFunctionName(this.getProxyIOPin()) : this.getOutputAction().getShortFunctionName();
    }

    public String getShortFunctionName() {
        return this.isSafetyInputPin() ? this.configurableNameProvider.getShortFunctionName(this.getProxyIOPin()) : this.getOutputAction().getShortFunctionName();
    }

    private ConfigurableIOPin getProxyIOPin() {
        ProxyConfigurationIOPin configurableIOPin = new ProxyConfigurationIOPin(this.isInput(), 200 + this.pin, this.configurableNameProvider, this.lookupService);
        ((ConfigurableIOPin)configurableIOPin).setIOPinAction(this.getIOPinAction());
        return configurableIOPin;
    }

    static {
        ToolIOPin.ajc$preClinit();
    }

    static final /* synthetic */ void setIOPinAction_aroundBody0(ToolIOPin ajc$this, PinAction action, JoinPoint joinPoint) {
        ajc$this.action = action;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ToolIOPin.java", ToolIOPin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setIOPinAction", "com.ur.polyscope.pin.ToolIOPin", "com.ur.polyscope.pin.PinAction", "action", "", "void"), 167);
    }
}

