/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.actions;

import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.Trigger;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.actions.InputPinActionLookupService;
import com.ur.polyscope.pin.actions.ProgramActionInvocation;
import com.ur.util.logging.Log;
import javax.inject.Inject;

public class InputPinActionLookupServiceImpl
implements InputPinActionLookupService {
    private static ProgramActionInvocation programActionInvocation;
    private static final DefaultInputPinAction START_ACTION;
    private static final DefaultInputPinAction STOP_ACTION;
    private static final DefaultInputPinAction PAUSE_ACTION;
    private static final DefaultInputPinAction FREEDRIVE_ACTION;

    static {
        START_ACTION = new DefaultInputPinAction(InputPinAction.START, new DefaultTrigger(){

            @Override
            public void onPress() {
                if (programActionInvocation != null) {
                    programActionInvocation.slowlyMoveToStartAndPlayOrResume();
                }
            }
        });
        STOP_ACTION = new DefaultInputPinAction(InputPinAction.STOP, new DefaultTrigger(){

            @Override
            public void onPress() {
                if (programActionInvocation != null) {
                    programActionInvocation.stopProgram();
                }
            }
        });
        PAUSE_ACTION = new DefaultInputPinAction(InputPinAction.PAUSE, new DefaultTrigger(){

            @Override
            public void onPress() {
                if (programActionInvocation != null) {
                    programActionInvocation.pauseProgram();
                }
            }
        });
        FREEDRIVE_ACTION = new DefaultInputPinAction(InputPinAction.FREEDRIVE, new DefaultTrigger(null, null));
    }

    @Inject
    public static void setProgramActionInvocation(ProgramActionInvocation programActionInvocation) {
        InputPinActionLookupServiceImpl.programActionInvocation = programActionInvocation;
    }

    @Override
    public PinAction getPinAction(InputPinAction inputPinAction) {
        Log.trace((String)("ACTION PRESS: " + this));
        switch (inputPinAction) {
            case NONE: {
                return DefaultInputPinAction.INPUT_PIN_ACTION_NONE;
            }
            case START: {
                return START_ACTION;
            }
            case STOP: {
                return STOP_ACTION;
            }
            case PAUSE: {
                return PAUSE_ACTION;
            }
            case FREEDRIVE: {
                return FREEDRIVE_ACTION;
            }
        }
        return null;
    }

    private static class DefaultTrigger
    implements Trigger {
        private DefaultTrigger() {
        }

        @Override
        public void onPress() {
        }

        @Override
        public void onRelease() {
        }

        /* synthetic */ DefaultTrigger(DefaultTrigger defaultTrigger, DefaultTrigger defaultTrigger2) {
            this();
        }
    }
}

