/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.actions;

import com.ur.polyscope.pin.internal.TextResource;
import com.ur.polyscope.viewfacade.pin.IOServiceType;

public enum OutputPinAction {
    NONE(false, true, false, 0, ""),
    LOW_WHEN_PROGRAM_STOPPED(false, false, true, 1, "Prog-Stop-LO"),
    HIGH_WHEN_PROGRAM_STOPPED(2, "Prog-Stop-HI"),
    PROGRAM_RUNNING(true, true, false, 3, "Prog-Running"),
    POWERED_PIN_0(true, true, true, 0, "Power"),
    POWERED_PIN_1(true, true, true, 0, "GND"),
    CONTINUOUS_PULSE(false, true, true, 0, "Cont-Pulse"),
    LOW_WHEN_PROGRAM_ABORTED(false, false, true, 4, "Prog-abort-LO"),
    LOW_WHEN_PROGRAM_ABORTED_HIGH_WHEN_NOT(true, true, false, 5, "Prog-abort"),
    DRIVE_POWER_INDICATOR(6, "Drive-Power-HI"),
    DRIVE_POWER_INDICATOR_HIGH_WHEN_NOT(7, "Drive-Power-LO");

    private boolean isProgramStateMode;
    private boolean isProgramStatePreservedAtProgramStop;
    private boolean programStopValue;
    private int runstateChoice;
    private String shortName;

    private OutputPinAction(boolean isProgramStateMode, boolean isProgramStatePreservedAtProgramStop, boolean programStopValue, int runstateChoice, String shortName) {
        this.isProgramStateMode = isProgramStateMode;
        this.isProgramStatePreservedAtProgramStop = isProgramStatePreservedAtProgramStop;
        this.programStopValue = programStopValue;
        this.runstateChoice = runstateChoice;
        this.shortName = shortName;
    }

    private OutputPinAction(int runstateChoice, String shortName) {
        this(false, false, false, runstateChoice, shortName);
    }

    @Deprecated
    public static OutputPinAction byValues(boolean isProgramStateMode, boolean isProgramStatePreservedAtProgramStop, boolean programStopValue) {
        OutputPinAction[] outputPinActionArray = OutputPinAction.values();
        int n = outputPinActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OutputPinAction each = outputPinActionArray[n2];
            if (each != LOW_WHEN_PROGRAM_ABORTED && each != LOW_WHEN_PROGRAM_ABORTED_HIGH_WHEN_NOT && each != POWERED_PIN_0 && each != POWERED_PIN_1 && each.isProgramStateMode == isProgramStateMode && each.isProgramStatePreservedAtProgramStop == isProgramStatePreservedAtProgramStop && each.programStopValue == programStopValue) {
                return each;
            }
            ++n2;
        }
        return NONE;
    }

    public static OutputPinAction getPoweredPinAction(int pin) {
        if (pin == 0) {
            return POWERED_PIN_0;
        }
        if (pin == 1) {
            return POWERED_PIN_1;
        }
        return NONE;
    }

    public int getRunstateChoice() {
        return this.runstateChoice;
    }

    @Deprecated
    public boolean isProgramStatePreservedAtProgramStop() {
        return this.isProgramStatePreservedAtProgramStop;
    }

    @Deprecated
    public boolean hasProgramStopValue() {
        return this.programStopValue;
    }

    public String getShortFunctionName() {
        return this.shortName;
    }

    public String getLongFunctionName(TextResource textResource, IOServiceType type) {
        String longName = "";
        switch (this) {
            case NONE: {
                longName = textResource.IONone();
                break;
            }
            case LOW_WHEN_PROGRAM_STOPPED: {
                longName = this.getNameForLowWhenStopped(textResource, type);
                break;
            }
            case HIGH_WHEN_PROGRAM_STOPPED: {
                longName = this.getNameForHighWhenStopped(textResource, type);
                break;
            }
            case PROGRAM_RUNNING: {
                longName = this.getNameForProgRunning(textResource, type);
                break;
            }
            case CONTINUOUS_PULSE: {
                longName = textResource.ContinuousPulse();
                break;
            }
            case LOW_WHEN_PROGRAM_ABORTED: {
                longName = this.getNameForLowWhenAborted(textResource, type);
                break;
            }
            case LOW_WHEN_PROGRAM_ABORTED_HIGH_WHEN_NOT: {
                longName = this.getNameForLowWhenAbortedElseHigh(textResource, type);
                break;
            }
            case DRIVE_POWER_INDICATOR: {
                longName = this.getNameForDrivePowerIndicatorHigh(textResource, type);
                break;
            }
            case DRIVE_POWER_INDICATOR_HIGH_WHEN_NOT: {
                longName = this.getNameForDrivePowerIndicatorLow(textResource, type);
                break;
            }
        }
        return longName;
    }

    private String getNameForLowWhenStopped(TextResource textResource, IOServiceType type) {
        boolean isHighLow;
        boolean isMinMax = type == IOServiceType.ANALOG;
        boolean isZeroOne = type == IOServiceType.FLOAT || type == IOServiceType.INTEGER;
        boolean bl = isHighLow = type == IOServiceType.DIGITAL || type == IOServiceType.BOOLEAN;
        if (isMinMax) {
            return textResource.IOMinWhenProgramNotRunning();
        }
        if (isZeroOne) {
            return textResource.IOZeroWhenProgramNotRunning();
        }
        if (isHighLow) {
            return textResource.IOLowWhenProgramNotRunning();
        }
        return "";
    }

    private String getNameForHighWhenStopped(TextResource textResource, IOServiceType type) {
        boolean isHighLow;
        boolean isMinMax = type == IOServiceType.ANALOG;
        boolean isZeroOne = type == IOServiceType.FLOAT || type == IOServiceType.INTEGER;
        boolean bl = isHighLow = type == IOServiceType.DIGITAL || type == IOServiceType.BOOLEAN;
        if (isMinMax) {
            return textResource.IOMaxWhenProgramNotRunning();
        }
        if (isZeroOne) {
            return textResource.IOOneWhenProgramNotRunning();
        }
        if (isHighLow) {
            return textResource.IOHighWhenProgramNotRunning();
        }
        return "";
    }

    private String getNameForProgRunning(TextResource textResource, IOServiceType type) {
        boolean isHighLow;
        boolean isMinMax = type == IOServiceType.ANALOG;
        boolean isZeroOne = type == IOServiceType.FLOAT || type == IOServiceType.INTEGER;
        boolean bl = isHighLow = type == IOServiceType.DIGITAL || type == IOServiceType.BOOLEAN;
        if (isMinMax) {
            return textResource.IOProgramRunningAnalog();
        }
        if (isZeroOne) {
            return textResource.IOProgramRunningZeroOne();
        }
        if (isHighLow) {
            return textResource.IOProgramRunning();
        }
        return "";
    }

    private String getNameForLowWhenAborted(TextResource textResource, IOServiceType type) {
        boolean isHighLow;
        boolean isMinMax = type == IOServiceType.ANALOG;
        boolean isZeroOne = type == IOServiceType.FLOAT || type == IOServiceType.INTEGER;
        boolean bl = isHighLow = type == IOServiceType.DIGITAL || type == IOServiceType.BOOLEAN;
        if (isMinMax) {
            return textResource.IOMinWHenAborted();
        }
        if (isZeroOne) {
            return textResource.IOZeroWhenAborted();
        }
        if (isHighLow) {
            return textResource.IOLowWhenAborted();
        }
        return "";
    }

    private String getNameForLowWhenAbortedElseHigh(TextResource textResource, IOServiceType type) {
        boolean isHighLow;
        boolean isMinMax = type == IOServiceType.ANALOG;
        boolean isZeroOne = type == IOServiceType.FLOAT || type == IOServiceType.INTEGER;
        boolean bl = isHighLow = type == IOServiceType.DIGITAL || type == IOServiceType.BOOLEAN;
        if (isMinMax) {
            return textResource.IOMinWHenAbortedMaxWhenNot();
        }
        if (isZeroOne) {
            return textResource.IOZeroWhenAbortedOneWhenNot();
        }
        if (isHighLow) {
            return textResource.IOLowWhenAbortedHighWhenNot();
        }
        return "";
    }

    private String getNameForDrivePowerIndicatorHigh(TextResource textResource, IOServiceType type) {
        boolean isHighLow;
        boolean isMinMax = type == IOServiceType.ANALOG;
        boolean isZeroOne = type == IOServiceType.FLOAT || type == IOServiceType.INTEGER;
        boolean bl = isHighLow = type == IOServiceType.DIGITAL || type == IOServiceType.BOOLEAN;
        if (isHighLow) {
            return textResource.IODrivePowerIndicatorHigh();
        }
        if (isZeroOne) {
            return textResource.IODrivePowerIndicatorOne();
        }
        if (isMinMax) {
            return textResource.IODrivePowerIndicatorMax();
        }
        return "";
    }

    private String getNameForDrivePowerIndicatorLow(TextResource textResource, IOServiceType type) {
        boolean isHighLow;
        boolean isMinMax = type == IOServiceType.ANALOG;
        boolean isZeroOne = type == IOServiceType.FLOAT || type == IOServiceType.INTEGER;
        boolean bl = isHighLow = type == IOServiceType.DIGITAL || type == IOServiceType.BOOLEAN;
        if (isHighLow) {
            return textResource.IODrivePowerIndicatorLow();
        }
        if (isZeroOne) {
            return textResource.IODrivePowerIndicatorZero();
        }
        if (isMinMax) {
            return textResource.IODrivePowerIndicatorMin();
        }
        return "";
    }
}

