/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.installation;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.ControllerConnectionListener;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class ResetIOsOnConnectionToController
implements ControllerConnectionListener {
    private static final Logger LOG = LogFactory.createLogger(ResetIOsOnConnectionToController.class);
    private static final int TIMEOUT = 1500;
    private final RobotInstallationSite lookupService;
    private ControllerInterface controllerInterface;

    @Inject
    public ResetIOsOnConnectionToController(RobotInstallationSite lookupService, ControllerInterface controllerInterface) {
        this.lookupService = lookupService;
        this.controllerInterface = controllerInterface;
    }

    public void connectedToController() {
        ((IOService)this.lookupService.getInstallation().getComponent(IOService.class)).resetOutputActions();
        this.pauseProgramIfRunning();
        this.setRealRobotBlocking();
        this.setControllerState();
    }

    private void setRealRobotBlocking() {
        if (this.controllerInterface.isConnected()) {
            if (!this.controllerInterface.runScript("set real\n")) {
                LOG.warn("Failed to 'set real' on controller", new Object[0]);
            }
            if (!Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                public boolean itHappened() {
                    return RobotState.getLatestRobotState().real;
                }
            }, (int)1500, (TimeUnit)TimeUnit.MILLISECONDS)) {
                EventNotificationService.notify(ControllerConnectionListener.class, (NotificationStrategy)new NotificationStrategy<ControllerConnectionListener>(){

                    public void notify(ControllerConnectionListener controllerConnectionListener) {
                        controllerConnectionListener.failedToSendMessage("set real");
                    }
                });
            }
        }
    }

    private void setControllerState() {
        ScriptWriter writer = new ScriptWriter();
        writer.defineSecondary("set_controller_state");
        this.lookupService.getInstallation().generatePreambleScript(writer);
        writer.end();
        if (!this.controllerInterface.runScript(writer.generateScript())) {
            LOG.warn("Failed to 'set_controller_state' on controller", new Object[0]);
        }
    }

    public void failedToSendMessage(String message) {
    }

    public void disconnectedFromController() {
    }

    private void pauseProgramIfRunning() {
        if (RobotState.getLatestRobotState().programRunning && !this.controllerInterface.runScript("pause program\n")) {
            LOG.warn("Failed to 'pause program' on controller", new Object[0]);
        }
    }
}

