/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.internal;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.AbstractPin;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.OutputActionPin;
import com.ur.polyscope.pin.PersistIOPart;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.actions.InputPinActionLookupService;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;

public class IOServiceConversionStrategy
extends ConversionStrategyTemplate<IOService> {
    private static final String DIGITAL_INPUT_NAMES = "DigitalInputNames";
    private static final String DIGITAL_OUTPUT_NAMES = "DigitalOutputNames";
    private static final String DIGITAL_INPUT_ACTIONS = "DigitalInputActions";
    private static final String DIGITAL_OUTPUT_ACTIONS = "DigitalOutputActions";
    private static final String TOOL_DIGITAL_INPUT_NAMES = "ToolDigitalInputNames";
    private static final String TOOL_DIGITAL_OUTPUT_NAMES = "ToolDigitalOutputNames";
    private static final String TOOL_DIGITAL_INPUT_ACTIONS = "ToolDigitalInputActions";
    private static final String TOOL_DIGITAL_OUTPUT_ACTIONS = "ToolDigitalOutputActions";
    private static final String TOOL_ANALOG_INPUT_NAMES = "ToolAnalogInputNames";
    private static final String ANALOG_INPUT_NAMES = "AnalogInputNames";
    private static final String ANALOG_OUTPUT_NAMES = "AnalogOutputNames";
    private static final String ANALOG_OUTPUT_ACTIONS = "AnalogOutputActions";
    private static final String CONFIGURABLE_INPUT_NAMES = "ConfigurableInputNames";
    private static final String CONFIGURABLE_OUTPUT_NAMES = "ConfigurableOutputNames";
    private static final String CONFIGURABLE_INPUT_ACTIONS = "ConfigurableInputActions";
    private static final String CONFIGURABLE_OUTPUT_ACTIONS = "ConfigurableOutputActions";
    private static final String OUTPUT_SIGNAL_OPTIONS = "outputSignalOptions";
    private static final String ANALOG_INPUT_RANGE = "analogInputRange";
    private static final String ANALOG_OUTPUT_DOMAIN = "analogOutputDomain";
    private final Set<PersistIOPart> ioConversionParts;
    private final Installation installation;
    private final IOService ioService;
    private final InputPinActionLookupService inputPinActionLookupService;

    @Inject
    public IOServiceConversionStrategy(Set<PersistIOPart> ioConversionParts, Installation installation, IOService ioService, InputPinActionLookupService inputPinActionLookupService) {
        super(IOService.class);
        this.ioConversionParts = new HashSet<PersistIOPart>(ioConversionParts);
        this.installation = installation;
        this.ioService = ioService;
        this.inputPinActionLookupService = inputPinActionLookupService;
    }

    public void marshal(IOService toMarshal, PersistWriter writer) {
        writer.createNodeWithValueAttribute(DIGITAL_INPUT_NAMES, this.getUserDefinedNames(this.ioService.getStandardDigitalInputPins()));
        writer.createNodeWithValueAttribute(DIGITAL_OUTPUT_NAMES, this.getUserDefinedNames(this.ioService.getStandardDigitalOutputPins()));
        writer.createNodeWithValueAttribute(TOOL_DIGITAL_INPUT_NAMES, this.getUserDefinedNames(this.ioService.getToolDigitalInputPins()));
        writer.createNodeWithValueAttribute(TOOL_DIGITAL_OUTPUT_NAMES, this.getUserDefinedNames(this.ioService.getToolDigitalOutputPins()));
        writer.createNodeWithValueAttribute(TOOL_ANALOG_INPUT_NAMES, this.getUserDefinedNames(this.ioService.getToolAnalogInputPins()));
        writer.createNodeWithValueAttribute(ANALOG_INPUT_NAMES, this.getUserDefinedNames(this.ioService.getStandardAnalogInputPins()));
        writer.createNodeWithValueAttribute(ANALOG_OUTPUT_NAMES, this.getUserDefinedNames(this.ioService.getStandardAnalogOutputPins()));
        writer.createNodeWithValueAttribute(CONFIGURABLE_INPUT_NAMES, this.getUserDefinedNames(this.ioService.getConfigurableDigitalInputPins()));
        writer.createNodeWithValueAttribute(CONFIGURABLE_OUTPUT_NAMES, this.getUserDefinedNames(this.ioService.getConfigurableDigitalOutputPins()));
        writer.createNodeWithValueAttribute(OUTPUT_SIGNAL_OPTIONS, AbstractPin.getOutputSignalOptions());
        writer.createNodeWithValueAttribute(ANALOG_INPUT_RANGE, ((IOService)this.installation.getComponent(IOService.class)).getAnalogInputRange());
        writer.createNodeWithValueAttribute(ANALOG_OUTPUT_DOMAIN, ((IOService)this.installation.getComponent(IOService.class)).getAnalogOutputDomain());
        writer.createNodeWithValueAttribute(DIGITAL_INPUT_ACTIONS, this.writeInputPinActions(this.ioService.getStandardDigitalInputPins()));
        writer.createNodeWithValueAttribute(TOOL_DIGITAL_INPUT_ACTIONS, this.writeInputPinActions(this.ioService.getToolDigitalInputPins()));
        writer.createNodeWithValueAttribute(CONFIGURABLE_INPUT_ACTIONS, this.writeInputPinActions(this.ioService.getConfigurableDigitalInputPins()));
        writer.createNodeWithValueAttribute(DIGITAL_OUTPUT_ACTIONS, this.writeOutputPinActions(this.ioService.getStandardDigitalOutputPins()));
        writer.createNodeWithValueAttribute(TOOL_DIGITAL_OUTPUT_ACTIONS, this.writeOutputPinActions(this.ioService.getToolDigitalOutputPins()));
        writer.createNodeWithValueAttribute(ANALOG_OUTPUT_ACTIONS, this.writeOutputPinActions(this.ioService.getStandardAnalogOutputPins()));
        writer.createNodeWithValueAttribute(CONFIGURABLE_OUTPUT_ACTIONS, this.writeOutputPinActions(this.ioService.getConfigurableDigitalOutputPins()));
        for (PersistIOPart each : this.ioConversionParts) {
            each.marshal(toMarshal, this.installation, writer);
        }
    }

    private String[] writeOutputPinActions(Pin<?>[] pins) {
        String[] r = new String[pins.length];
        int i = 0;
        while (i < pins.length) {
            r[i] = ((OutputActionPin)pins[i]).getOutputAction().name();
            ++i;
        }
        return r;
    }

    private String[] writeInputPinActions(Pin<?>[] pins) {
        String[] r = new String[pins.length];
        int i = 0;
        while (i < pins.length) {
            if (pins[i] instanceof InputActionPin && ((InputActionPin)pins[i]).getIOPinAction() instanceof DefaultInputPinAction) {
                InputActionPin ioPin = (InputActionPin)pins[i];
                r[i] = ioPin.getIOPinAction().name();
            } else {
                r[i] = InputPinAction.NONE.name();
            }
            ++i;
        }
        return r;
    }

    public IOService unmarshal(PersistReader reader) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode(DIGITAL_INPUT_NAMES)) {
                this.setUserDefinedNames(this.ioService.getStandardDigitalInputPins(), reader.getStringValueArray());
            } else if (reader.isNode(DIGITAL_OUTPUT_NAMES)) {
                this.setUserDefinedNames(this.ioService.getStandardDigitalOutputPins(), reader.getStringValueArray());
            } else if (reader.isNode(DIGITAL_INPUT_ACTIONS)) {
                this.readPinActions(this.ioService.getStandardDigitalInputPins(), reader.getStringValueArray());
            } else if (reader.isNode(TOOL_DIGITAL_INPUT_ACTIONS)) {
                this.readPinActions(this.ioService.getToolDigitalInputPins(), reader.getStringValueArray());
            } else if (reader.isNode(CONFIGURABLE_INPUT_ACTIONS)) {
                this.readPinActions(this.ioService.getConfigurableDigitalInputPins(), reader.getStringValueArray());
            }
            if (reader.isNode(TOOL_DIGITAL_INPUT_NAMES)) {
                this.setUserDefinedNames(this.ioService.getToolDigitalInputPins(), reader.getStringValueArray());
            } else if (reader.isNode(TOOL_DIGITAL_OUTPUT_NAMES)) {
                this.setUserDefinedNames(this.ioService.getToolDigitalOutputPins(), reader.getStringValueArray());
            } else if (reader.isNode(TOOL_ANALOG_INPUT_NAMES)) {
                this.setUserDefinedNames(this.ioService.getToolAnalogInputPins(), reader.getStringValueArray());
            }
            if (reader.isNode(ANALOG_INPUT_NAMES)) {
                this.setUserDefinedNames(this.ioService.getStandardAnalogInputPins(), reader.getStringValueArray());
            } else if (reader.isNode(ANALOG_OUTPUT_NAMES)) {
                this.setUserDefinedNames(this.ioService.getStandardAnalogOutputPins(), reader.getStringValueArray());
            }
            if (reader.isNode(CONFIGURABLE_INPUT_NAMES)) {
                this.setUserDefinedNames(this.ioService.getConfigurableDigitalInputPins(), reader.getStringValueArray());
            } else if (reader.isNode(CONFIGURABLE_OUTPUT_NAMES)) {
                this.setUserDefinedNames(this.ioService.getConfigurableDigitalOutputPins(), reader.getStringValueArray());
            }
            if (reader.isNode(OUTPUT_SIGNAL_OPTIONS)) {
                AbstractPin.setOutputSignalOptions(reader.getIntegerArrayValueAttribute());
            } else if (reader.isNode(ANALOG_INPUT_RANGE)) {
                ((IOService)this.installation.getComponent(IOService.class)).setAnalogInputRange(reader.getIntegerArrayValueAttribute());
            } else if (reader.isNode(ANALOG_OUTPUT_DOMAIN)) {
                ((IOService)this.installation.getComponent(IOService.class)).setAnalogOutputDomain(reader.getIntegerArrayValueAttribute());
            }
            if (reader.isNode(DIGITAL_OUTPUT_ACTIONS)) {
                this.readOutputPinActions(this.ioService.getStandardDigitalOutputPins(), reader.getStringValueArray());
            }
            if (reader.isNode(TOOL_DIGITAL_OUTPUT_ACTIONS)) {
                this.readOutputPinActions(this.ioService.getToolDigitalOutputPins(), reader.getStringValueArray());
            }
            if (reader.isNode(ANALOG_OUTPUT_ACTIONS)) {
                this.readOutputPinActions(this.ioService.getStandardAnalogOutputPins(), reader.getStringValueArray());
            }
            if (reader.isNode(CONFIGURABLE_OUTPUT_ACTIONS)) {
                this.readOutputPinActions(this.ioService.getConfigurableDigitalOutputPins(), reader.getStringValueArray());
            }
            for (PersistIOPart each : this.ioConversionParts) {
                if (!each.canUnmarshal(reader)) continue;
                each.unmarshal(this.installation, reader);
            }
            reader.moveToParentNode();
        }
        return this.ioService;
    }

    private void readPinActions(Pin<?>[] pins, String[] strings) {
        int length = Math.min(pins.length, strings.length);
        int i = 0;
        while (i < length) {
            if (pins[i] instanceof InputActionPin) {
                InputActionPin ioPin = (InputActionPin)pins[i];
                ioPin.setIOPinAction(this.inputPinActionLookupService.getPinAction(Enum.valueOf(InputPinAction.class, strings[i])));
            }
            ++i;
        }
    }

    private void readOutputPinActions(Pin<?>[] pins, String[] strings) {
        int length = Math.min(pins.length, strings.length);
        int i = 0;
        while (i < length) {
            if (pins[i] instanceof OutputActionPin) {
                OutputActionPin ioPin = (OutputActionPin)pins[i];
                ioPin.setOutputAction(Enum.valueOf(OutputPinAction.class, strings[i]));
            }
            ++i;
        }
    }

    private String[] getUserDefinedNames(Pin<?>[] pins) {
        String[] result = new String[pins.length];
        int i = 0;
        while (i < pins.length) {
            result[i] = pins[i].getUserDefinedName();
            ++i;
        }
        return result;
    }

    private void setUserDefinedNames(Pin<?>[] pins, String[] names) {
        int length = Math.min(pins.length, names.length);
        int i = 0;
        while (i < length) {
            pins[i].setName(names[i]);
            ++i;
        }
    }
}

