/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.internal;

import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamedEntitySource;
import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.installation.IgnorePersistence;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.io.tool.InternalToolIOService;
import com.ur.polyscope.pin.AbstractPin;
import com.ur.polyscope.pin.AbstractRegister;
import com.ur.polyscope.pin.AnalogIOPin;
import com.ur.polyscope.pin.ConfigurableIOPin;
import com.ur.polyscope.pin.ConfigurableName;
import com.ur.polyscope.pin.CustomIOServiceImpl;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.GeneralPurposeBooleanRegister;
import com.ur.polyscope.pin.GeneralPurposeFloatRegister;
import com.ur.polyscope.pin.GeneralPurposeIntRegister;
import com.ur.polyscope.pin.GeneralPurposeRegisterListener;
import com.ur.polyscope.pin.IOPinLookup;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.InputPinLookup;
import com.ur.polyscope.pin.ModifiablePin;
import com.ur.polyscope.pin.OutputActionPin;
import com.ur.polyscope.pin.OutputPinLookup;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.pin.StandardIOPin;
import com.ur.polyscope.pin.ToolIOPin;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.pin.service.IOInterface;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.pin.service.ToolIOPinService;
import com.ur.polyscope.scriptwriter.PreambleScript;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.util.Predicate;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.ToolOutputMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class IOServiceImpl
extends CustomIOServiceImpl
implements IgnorePersistence,
InternalToolIOService,
IOService,
NamedEntitySource,
GeneralPurposeRegisterListener.All,
PreambleScript {
    private static final String CUSTOM_IO_DEFAULT_NAME = "custom_io";
    public static final int _0_TO_10V = 1;
    public static final int _4_TO_20mA = 0;
    private final Set<IOInterface> ioInterfaces;
    private ConfigurableName configurableName;
    private final InstallationComponentLookup lookupService;
    private final StandardIOPin[] standardDigitalOutput = new StandardIOPin[8];
    private final StandardIOPin[] standardDigitalInput = new StandardIOPin[8];
    private final ToolIOPin[] toolDigitalInput = new ToolIOPin[2];
    private final ToolIOPin[] toolDigitalOutput = new ToolIOPin[2];
    private final AnalogIOPin[] standardAnalogOutput = new AnalogIOPin[2];
    private final AnalogIOPin[] analogInput = new AnalogIOPin[4];
    private final AnalogIOPin[] standardAnalogInput = new AnalogIOPin[2];
    private final AnalogIOPin[] toolAnalogInput = new AnalogIOPin[2];
    private final ConfigurableIOPin[] configurableDigitalOutput = new ConfigurableIOPin[8];
    private final ConfigurableIOPin[] configurableDigitalInput = new ConfigurableIOPin[8];
    private final GeneralPurposeBooleanRegister[] booleanRegisterInput = new GeneralPurposeBooleanRegister[128];
    private final GeneralPurposeBooleanRegister[] booleanRegisterOutput = new GeneralPurposeBooleanRegister[128];
    private final GeneralPurposeIntRegister[] intRegisterInput = new GeneralPurposeIntRegister[48];
    private final GeneralPurposeIntRegister[] intRegisterOutput = new GeneralPurposeIntRegister[48];
    private final GeneralPurposeFloatRegister[] floatRegisterInput = new GeneralPurposeFloatRegister[48];
    private final GeneralPurposeFloatRegister[] floatRegisterOutput = new GeneralPurposeFloatRegister[48];
    private int[] analogInputRange = PrimitiveUtils.initArray((int[])new int[4], (int)1);
    private int[] analogOutputDomain = new int[2];
    private IOPinLookup inputPinLookup;
    private IOPinLookup outputPinLookup;
    private HashSet<NamedEntity> allNamedEntitiesPins;
    private ControllerInterface controllerInterface;
    private final ToolIOPinService toolIOPinService;

    @Inject
    public IOServiceImpl(Set<IOInterface> ioInterfaces, ConfigurableName configurableName, InstallationComponentLookup installationLookupService, ControllerInterface controllerInterface, ToolIOPinService toolIOPinService) {
        this.ioInterfaces = new HashSet<IOInterface>(ioInterfaces);
        this.configurableName = configurableName;
        this.lookupService = installationLookupService;
        this.controllerInterface = controllerInterface;
        this.toolIOPinService = toolIOPinService;
        if (this.standardDigitalInput[0] == null) {
            this.createStandardPins(this.standardDigitalOutput, false);
            this.createStandardPins(this.standardDigitalInput, true);
            this.createToolPins(this.toolDigitalOutput, false);
            this.createToolPins(this.toolDigitalInput, true);
            this.createConfigurablePins(this.configurableDigitalOutput, false);
            this.createConfigurablePins(this.configurableDigitalInput, true);
            this.createAnalogPins(this.standardAnalogOutput, false);
            this.createAnalogPins(this.analogInput, true);
            this.createStandardAnalogInputPins();
            this.createToolAnalogInputPins();
            this.createGPBooleanInputRegisters();
            this.createGPBooleanOutputRegisters();
            this.createGPIntInputRegisters();
            this.createGPIntOutputRegisters();
            this.createGPFloatInputRegisters();
            this.createGPFloatOutputRegisters();
            this.inputPinLookup = new InputPinLookup(this, this.lookupService, this.ioInterfaces);
            this.outputPinLookup = new OutputPinLookup(this, this.lookupService, this.ioInterfaces);
        }
    }

    @Override
    public void setComponent(IOInterface component) {
        this.ioInterfaces.add(component);
    }

    private void createGPBooleanOutputRegisters() {
        int i = 0;
        while (i < 128) {
            this.booleanRegisterOutput[i] = new GeneralPurposeBooleanRegister(i, false, false);
            ++i;
        }
    }

    private void createGPBooleanInputRegisters() {
        int i = 0;
        while (i < 128) {
            this.booleanRegisterInput[i] = new GeneralPurposeBooleanRegister(i, false, true);
            ++i;
        }
    }

    private void createGPIntOutputRegisters() {
        int i = 0;
        while (i < 48) {
            this.intRegisterOutput[i] = new GeneralPurposeIntRegister(i, 0, false);
            ++i;
        }
    }

    private void createGPIntInputRegisters() {
        int i = 0;
        while (i < 48) {
            this.intRegisterInput[i] = new GeneralPurposeIntRegister(i, 0, true);
            ++i;
        }
    }

    private void createGPFloatOutputRegisters() {
        int i = 0;
        while (i < 48) {
            this.floatRegisterOutput[i] = new GeneralPurposeFloatRegister(i, 0.0, false);
            ++i;
        }
    }

    private void createGPFloatInputRegisters() {
        int i = 0;
        while (i < 48) {
            this.floatRegisterInput[i] = new GeneralPurposeFloatRegister(i, 0.0, true);
            ++i;
        }
    }

    private void createToolAnalogInputPins() {
        int pin = 0;
        while (pin < 2) {
            this.toolAnalogInput[pin] = this.analogInput[2 + pin];
            ++pin;
        }
    }

    private void createStandardAnalogInputPins() {
        int pin = 0;
        while (pin < 2) {
            this.standardAnalogInput[pin] = this.analogInput[pin];
            ++pin;
        }
    }

    private void createStandardPins(StandardIOPin[] pins, boolean isInput) {
        int pin = 0;
        while (pin < pins.length) {
            pins[pin] = new StandardIOPin(isInput, pin, this);
            ++pin;
        }
    }

    private void createToolPins(ToolIOPin[] pins, boolean isInput) {
        int pin = 0;
        while (pin < pins.length) {
            pins[pin] = new ToolIOPin(isInput, pin, this.configurableName, this.lookupService, this.toolIOPinService);
            ++pin;
        }
    }

    private void createAnalogPins(AnalogIOPin[] pins, boolean isInput) {
        int pin = 0;
        while (pin < pins.length) {
            pins[pin] = new AnalogIOPin(isInput, pin, this.lookupService);
            ++pin;
        }
    }

    private void createConfigurablePins(ConfigurableIOPin[] pins, boolean isInput) {
        int pin = 0;
        while (pin < pins.length) {
            pins[pin] = new ConfigurableIOPin(isInput, pin, this.configurableName, this.lookupService);
            ++pin;
        }
    }

    @Override
    public Set<NamedEntity> getAllUserDefinedPins() {
        this.initializeAllNamedEntitiesPins();
        HashSet<NamedEntity> result = new HashSet<NamedEntity>();
        for (NamedEntity each : this.allNamedEntitiesPins) {
            if (StringUtils.isNullOrOnlyWhitespace((String)each.getName())) continue;
            result.add(each);
        }
        return result;
    }

    private void initializeAllNamedEntitiesPins() {
        if (this.allNamedEntitiesPins == null) {
            this.allNamedEntitiesPins = new HashSet();
            this.createEntities(this.allNamedEntitiesPins, this.standardDigitalOutput);
            this.createEntities(this.allNamedEntitiesPins, this.standardDigitalInput);
            this.createEntities(this.allNamedEntitiesPins, this.toolDigitalInput);
            this.createEntities(this.allNamedEntitiesPins, this.toolDigitalOutput);
            this.createEntities(this.allNamedEntitiesPins, this.standardAnalogOutput);
            this.createEntities(this.allNamedEntitiesPins, this.analogInput);
            this.createEntities(this.allNamedEntitiesPins, this.configurableDigitalOutput);
            this.createEntities(this.allNamedEntitiesPins, this.configurableDigitalInput);
            this.createEntities(this.allNamedEntitiesPins, this.booleanRegisterInput);
            this.createEntities(this.allNamedEntitiesPins, this.booleanRegisterOutput);
            this.createEntities(this.allNamedEntitiesPins, this.intRegisterInput);
            this.createEntities(this.allNamedEntitiesPins, this.intRegisterOutput);
            this.createEntities(this.allNamedEntitiesPins, this.floatRegisterInput);
            this.createEntities(this.allNamedEntitiesPins, this.floatRegisterOutput);
        }
    }

    private void createEntities(Set<NamedEntity> entities, Pin<?>[] pins) {
        Pin<?>[] pinArray = pins;
        int n = pins.length;
        int n2 = 0;
        while (n2 < n) {
            Pin<?> pin2 = pinArray[n2];
            entities.add((NamedEntity)pin2);
            ++n2;
        }
    }

    @Override
    public Pin<?>[] getConfigurableDigitalInputPins() {
        return this.configurableDigitalInput;
    }

    @Override
    public Pin<?>[] getConfigurableDigitalOutputPins() {
        return this.configurableDigitalOutput;
    }

    @Override
    public Pin<?>[] getToolDigitalInputPins() {
        return this.toolDigitalInput;
    }

    @Override
    public Pin<?>[] getToolDigitalOutputPins() {
        return this.toolDigitalOutput;
    }

    @Override
    public Pin<?>[] getStandardAnalogInputPins() {
        return this.standardAnalogInput;
    }

    @Override
    public Pin<?>[] getAllAnalogInputPins() {
        return this.analogInput;
    }

    @Override
    public Pin<?>[] getToolAnalogInputPins() {
        return this.toolAnalogInput;
    }

    @Override
    public Pin<?>[] getStandardAnalogOutputPins() {
        return this.standardAnalogOutput;
    }

    @Override
    public Pin<?>[] getStandardDigitalInputPins() {
        return this.standardDigitalInput;
    }

    @Override
    public Pin<?>[] getStandardDigitalOutputPins() {
        return this.standardDigitalOutput;
    }

    @Override
    public Register<?>[] getGeneralPurposeBooleanInputRegisters() {
        return this.booleanRegisterInput;
    }

    @Override
    public Register<?>[] getGeneralPurposeBooleanOutputRegisters() {
        return this.booleanRegisterOutput;
    }

    @Override
    public Register<?>[] getGeneralPurposeIntInputRegisters() {
        return this.intRegisterInput;
    }

    @Override
    public Register<?>[] getGeneralPurposeIntOutputRegisters() {
        return this.intRegisterOutput;
    }

    @Override
    public Register<?>[] getGeneralPurposeFloatInputRegisters() {
        return this.floatRegisterInput;
    }

    @Override
    public Register<?>[] getGeneralPurposeFloatOutputRegisters() {
        return this.floatRegisterOutput;
    }

    @Override
    public List<Pin<?>> getOutputs(IOService.IOInterfaceType type, IOService.IOSignalType filter) {
        ArrayList result = new ArrayList();
        for (IOInterface each : this.ioInterfaces) {
            result.addAll(each.getOutputs(type, filter));
        }
        return result;
    }

    @Override
    public List<Pin<?>> getInputs(IOService.IOInterfaceType type, IOService.IOSignalType filter) {
        ArrayList result = new ArrayList();
        for (IOInterface each : this.ioInterfaces) {
            result.addAll(each.getInputs(type, filter));
        }
        return result;
    }

    @Override
    public List<Pin<?>> getAllOutputs() {
        return this.outputPinLookup.getPinList();
    }

    @Override
    public List<Pin<?>> getAllInputs() {
        return this.inputPinLookup.getPinList();
    }

    @Override
    public Pin<?> getPinWithName(String defaultName) {
        Pin<?> result = this.inputPinLookup.getPinByName(defaultName);
        if (result == null) {
            result = this.outputPinLookup.getPinByName(defaultName);
        }
        return result;
    }

    @Override
    public void resetPinNamesAndActions() {
        if (this.lookupService.hasInstallation()) {
            this.resetPins(this.standardDigitalOutput);
            this.resetPins(this.standardDigitalInput);
            this.resetPins(this.toolDigitalInput);
            this.resetPins(this.toolDigitalOutput);
            this.resetPins(this.standardAnalogOutput);
            this.resetPins(this.analogInput);
            this.resetPins(this.configurableDigitalOutput);
            this.resetPins(this.configurableDigitalInput);
            this.resetPins(this.booleanRegisterInput);
            this.resetPins(this.booleanRegisterOutput);
            this.resetPins(this.intRegisterInput);
            this.resetPins(this.intRegisterOutput);
            this.resetPins(this.floatRegisterInput);
            this.resetPins(this.floatRegisterOutput);
        }
    }

    private void resetPins(Pin<?>[] pins) {
        Pin<?>[] pinArray = pins;
        int n = pins.length;
        int n2 = 0;
        while (n2 < n) {
            Pin<?> each = pinArray[n2];
            each.setName("");
            if (each instanceof InputActionPin) {
                ((InputActionPin)each).setIOPinAction(DefaultInputPinAction.INPUT_PIN_ACTION_NONE);
            }
            if (each instanceof ModifiablePin) {
                ((ModifiablePin)each).setModificationChoice(0);
            }
            if (each instanceof OutputActionPin) {
                ((OutputActionPin)each).setOutputAction(OutputPinAction.NONE);
            }
            ++n2;
        }
    }

    @Override
    public void updateBooleanRegisters(boolean[] inputRegisters, boolean[] outputRegisters) {
        int i = 0;
        while (i < inputRegisters.length) {
            this.booleanRegisterInput[i].setValue(inputRegisters[i]);
            ++i;
        }
        i = 0;
        while (i < outputRegisters.length) {
            this.booleanRegisterOutput[i].setValue(outputRegisters[i]);
            ++i;
        }
    }

    @Override
    public void updateIntRegisters(int[] inputRegisters, int[] outputRegisters) {
        int i = 0;
        while (i < inputRegisters.length) {
            this.intRegisterInput[i].setValue(inputRegisters[i]);
            ++i;
        }
        i = 0;
        while (i < outputRegisters.length) {
            this.intRegisterOutput[i].setValue(outputRegisters[i]);
            ++i;
        }
    }

    @Override
    public void updateFloatRegisters(double[] inputRegisters, double[] outputRegisters) {
        int i = 0;
        while (i < inputRegisters.length) {
            this.floatRegisterInput[i].setValue(inputRegisters[i]);
            ++i;
        }
        i = 0;
        while (i < outputRegisters.length) {
            this.floatRegisterOutput[i].setValue(outputRegisters[i]);
            ++i;
        }
    }

    @Override
    public void resetOutputActions() {
        if (this.controllerInterface.isConnected()) {
            ScriptWriter writer = new ScriptWriter();
            writer.defineSecondary("reset_output_actions");
            writer.appendLine("reset_runstate_gp()");
            this.appendSetOutputRunstate(writer);
            writer.end();
            this.controllerInterface.runScript(writer.generateScript());
        }
    }

    private void appendSetOutputRunstate(ScriptWriter writer) {
        for (Pin<?> each : this.getAllOutputs()) {
            if (!(each instanceof OutputActionPin)) continue;
            this.appendSetOutputRunstate(writer, (OutputActionPin)each);
        }
    }

    private void appendSetOutputRunstate(ScriptWriter writer, OutputActionPin pin) {
        if (IOServiceImpl.safetyControlledPin(pin) || this.generalRegisterWithActionNone(pin)) {
            return;
        }
        writer.appendLine(pin.appendSetOutputRunstateDependentChoice(pin.getOutputAction().getRunstateChoice()));
    }

    private static boolean safetyControlledPin(OutputActionPin pin) {
        return pin instanceof ConfigurableIOPin && ((ConfigurableIOPin)pin).isSafetyOutputPin();
    }

    private boolean generalRegisterWithActionNone(OutputActionPin pin) {
        OutputPinAction action = pin.getOutputAction();
        return pin instanceof AbstractRegister && action == OutputPinAction.NONE;
    }

    @Override
    public Predicate<Pin<?>> getToolCommEnabledPredicate(boolean enabled) {
        return new ToolCommEnabled(enabled);
    }

    public boolean canGenerateScriptCode() {
        return true;
    }

    public void generatePreambleScript(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        int i = 0;
        while (i < 2) {
            writer.appendLine("set_standard_analog_input_domain(" + i + ", " + this.analogInputRange[i] + ")");
            ++i;
        }
        i = 0;
        while (i < 2) {
            writer.appendLine("set_tool_analog_input_domain(" + i + ", " + this.analogInputRange[i + 2] + ")");
            ++i;
        }
        i = 0;
        while (i < 2) {
            writer.appendLine("set_analog_outputdomain(" + i + ", " + this.analogOutputDomain[i] + ")");
            ++i;
        }
        this.appendSetRunstateInputs(writer);
        this.appendSetRunstateOutputs(writer);
        for (Pin<?> each : this.getAllOutputs()) {
            if (!(each instanceof OutputActionPin)) continue;
            ((OutputActionPin)each).generatePreambleScript(writer);
        }
    }

    private ScriptWriter appendSetRunstateInputs(ScriptWriter writer) {
        writer.appendLine("set_input_actions_to_default()");
        for (Pin<?> pin : this.getAllInputs()) {
            boolean isFreeDrive;
            if (!(pin instanceof InputActionPin)) continue;
            InputActionPin actionPin = (InputActionPin)pin;
            PinAction pinAction = actionPin.getIOPinAction();
            boolean bl = isFreeDrive = pinAction instanceof DefaultInputPinAction && ((DefaultInputPinAction)pinAction).getInputPinAction() == InputPinAction.FREEDRIVE;
            if (!isFreeDrive) continue;
            writer.appendLine(actionPin.generateInputActionScriptCode());
        }
        return writer;
    }

    private StringBuffer createListForSetRunstateOutputs(Pin<?>[] pins) {
        StringBuffer outputToClearList = new StringBuffer();
        int i = 0;
        while (i < pins.length) {
            OutputPinAction action = ((AbstractPin)pins[i]).getOutputAction();
            if (!action.isProgramStatePreservedAtProgramStop() && action.hasProgramStopValue()) {
                if (outputToClearList.length() > 0) {
                    outputToClearList.append("," + i);
                } else {
                    outputToClearList.append("" + i);
                }
            }
            ++i;
        }
        return outputToClearList;
    }

    @Override
    public ScriptWriter appendSetRunstateOutputs(ScriptWriter writer) {
        StringBuffer outputToClearList = this.createListForSetRunstateOutputs(this.getStandardDigitalOutputPins());
        if (outputToClearList.length() > 0) {
            writer.appendLine("set_runstate_standard_digital_outputs([" + outputToClearList + "])");
        }
        if ((outputToClearList = this.createListForSetRunstateOutputs(this.getToolDigitalOutputPins())).length() > 0) {
            writer.appendLine("set_runstate_tool_digital_outputs([" + outputToClearList + "])");
        }
        if ((outputToClearList = this.createListForSetRunstateOutputs(this.getStandardAnalogOutputPins())).length() > 0) {
            writer.appendLine("set_runstate_standard_analog_outputs([" + outputToClearList + "])");
        }
        if ((outputToClearList = this.createListForSetRunstateOutputs(this.getConfigurableDigitalOutputPins())).length() > 0) {
            writer.appendLine("set_runstate_configurable_digital_outputs([" + outputToClearList + "])");
        }
        return writer;
    }

    @Override
    public int[] getAnalogInputRange() {
        return this.analogInputRange;
    }

    @Override
    public void setAnalogInputRange(int[] integerArrayAttribute) {
        this.analogInputRange = integerArrayAttribute;
    }

    @Override
    public int[] getAnalogOutputDomain() {
        return this.analogOutputDomain;
    }

    @Override
    public void setAnalogOutputDomain(int[] integerArrayAttribute) {
        this.analogOutputDomain = integerArrayAttribute;
    }

    public String getToolAnalogInputPinDisplayName(int index) {
        return this.getToolAnalogInputPins()[index].getDisplayName();
    }

    public int getToolDigitalOutputPinModificationChoice(int index) {
        return ((ToolIOPin)this.getToolDigitalOutputPins()[index]).getModificationChoice();
    }

    public boolean isIOPinEnabled(int index) {
        OutputPinAction action = ((ToolIOPin)this.getToolDigitalOutputPins()[index]).getOutputAction();
        return action == OutputPinAction.NONE;
    }

    public void configureOutputPins(ToolOutputMode outputMode) {
        Pin<?>[] pins = this.getToolDigitalOutputPins();
        ToolIOPin pin0 = (ToolIOPin)pins[0];
        ToolIOPin pin1 = (ToolIOPin)pins[1];
        if (outputMode == ToolOutputMode.POWER) {
            pin0.setOutputAction(OutputPinAction.POWERED_PIN_0);
            pin1.setOutputAction(OutputPinAction.POWERED_PIN_1);
        } else {
            pin0.setOutputAction(OutputPinAction.NONE);
            pin1.setOutputAction(OutputPinAction.NONE);
        }
        this.sendAsSecondaryProgram(pin0.generateRunstateDependentChoice());
        this.sendAsSecondaryProgram(pin1.generateRunstateDependentChoice());
    }

    private void sendAsSecondaryProgram(String s) {
        StringBuffer b = new StringBuffer();
        b.append("sec p():\n");
        b.append("  ").append(s).append("\n");
        b.append("end\n");
        this.controllerInterface.runScript(b.toString());
    }

    @Override
    public int getAnalogInputRange(int index) {
        return this.analogInputRange[index];
    }

    @Override
    public void setAnalogInputRange(int index, int analogInputRange) {
        if (this.analogInputRange[index] != analogInputRange) {
            Log.info((String)("Update: {analogInputRange[" + index + "]: " + analogInputRange + "}"));
            this.analogInputRange[index] = analogInputRange;
            this.fireInstallationChangedEvent();
        }
    }

    @Override
    public int getAnalogOutputDomain(int index) {
        return this.analogOutputDomain[index];
    }

    @Override
    public void setAnalogOutputDomain(int index, int analogOutputDomain) {
        this.analogOutputDomain[index] = analogOutputDomain;
        this.fireInstallationChangedEvent();
    }

    public void fireInstallationChangedEvent() {
        if (RobotState.getLatestRobotState().real) {
            EventNotificationService.notify(InstallationStateListener.class, listener -> listener.installationModified());
        }
    }

    public Collection<? extends NamedEntity> getNamedEntities() {
        return this.getAllUserDefinedPins();
    }

    public Collection<? extends String> reservedNames() {
        return Collections.singleton(CUSTOM_IO_DEFAULT_NAME);
    }

    public Class<?> getType() {
        return IOService.class;
    }

    private static class ToolCommEnabled
    implements Predicate<Pin<?>> {
        private boolean enabled;

        public ToolCommEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean test(Pin<?> pin) {
            if (this.enabled) {
                if (pin instanceof AnalogIOPin && pin.isInput()) {
                    return pin.getPin() < 2;
                }
                return true;
            }
            return true;
        }
    }
}

