/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.iotab;

import com.ur.polyscope.controllerinterface.ControllerInterface;
import javax.inject.Inject;

public final class ControllerSocketSender {
    private static final String END_PROGRAM = "end\n";
    private static final String SEC_SET_DIGITAL_IN = "sec setDigitalIn():\n";
    private static final String SEC_SET_DIGITAL_OUT = "sec setDigitalOut():\n";
    private static ControllerInterface controllerInterface;

    private ControllerSocketSender() {
    }

    @Inject
    public static void setControllerInterface(ControllerInterface controllerInterface) {
        ControllerSocketSender.controllerInterface = controllerInterface;
    }

    public static void sendSetDigitalIn(int portNo, boolean val) {
        String b = "sec setDigitalIn():\n  digital_in[" + portNo + "] = " + ControllerSocketSender.toControllerBoolean(val) + "\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetDigitalOut(int portNo, boolean val) {
        String b = "sec setDigitalOut():\n  digital_out[" + portNo + "] = " + ControllerSocketSender.toControllerBoolean(val) + "\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetConfigurableOut(int portNo, boolean val) {
        String b = "sec setDigitalOut():\n  set_configurable_digital_out(" + portNo + ", " + ControllerSocketSender.toControllerBoolean(val) + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetConfigurableIn(int portNo, boolean val) {
        String b = "sec setDigitalIn():\n  set_configurable_digital_in(" + portNo + ", " + ControllerSocketSender.toControllerBoolean(val) + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetToolOut(int portNo, boolean val) {
        String b = "sec setDigitalOut():\n  set_tool_digital_out(" + portNo + ", " + ControllerSocketSender.toControllerBoolean(val) + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetToolIn(int portNo, boolean val) {
        String b = "sec setDigitalIn():\n  set_tool_digital_in(" + portNo + ", " + ControllerSocketSender.toControllerBoolean(val) + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetAnalogInputDomain(int portNo, int val) {
        String b = "sec setAnalogInputDomain():\n  set_standard_analog_input_domain(" + portNo + ", " + val + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetToolAnalogInputDomain(int portNo, int val) {
        String b = "sec setToolAnalogInputDomain():\n  set_tool_analog_input_domain(" + portNo + ", " + val + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetAnalogOutputDomain(int portNo, int idx) {
        String b = "sec setAnaolgOutputDomain():\n  set_analog_outputdomain(" + portNo + ", " + idx + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetAnalogOut(int portNo, double val) {
        String b = "sec setStandardAnalogOut():\n  set_standard_analog_out(" + portNo + ", " + val + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetToolVoltage(int val) {
        if (val == 0 || val == 12 || val == 24) {
            String b = "sec setToolVoltage():\n  set_tool_voltage(" + val + ")\n" + END_PROGRAM;
            controllerInterface.runScript(b);
        }
    }

    public static void sendAsSecondaryProgram(String s) {
        String b = "sec p():\n  " + s + "\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    static String toControllerBoolean(boolean b) {
        return b ? "True" : "False";
    }
}

