/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.iotab;

import com.ur.polyscope.pin.impl.ButtonImageResource;
import com.ur.polyscope.pin.iotab.PinName;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.FontFactory;
import com.ur.swing.URFontFactory;
import com.ur.util.swing.HTML;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class DigitalNamedIO
extends JPanel {
    private static final String TRUNCATE_SUFFIX = "...";
    private static final Icon LOCKED_OUTPUT_ON = ButtonImageResource.blueLed();
    private static final Icon LOCKED_OUTPUT_OFF = ButtonImageResource.grayLed();
    private static final Icon OUTPUT_ON = ButtonImageResource.rbs();
    private static final Icon OUTPUT_OFF = ButtonImageResource.rb();
    private final PinName name = new PinName();
    private final URFontFactory fontFactory;
    private Pin<?> pin;
    private boolean ioPanelEnabled = true;
    private boolean selected = false;
    private final List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private JLabel label;

    public DigitalNamedIO() {
        this.fontFactory = new FontFactory();
        this.initComponents();
    }

    public DigitalNamedIO(URFontFactory fontFactory) {
        this.fontFactory = fontFactory;
        this.initComponents();
    }

    public void initialize(Pin<?> pin) {
        this.pin = pin;
        this.setSelected(false);
    }

    public Pin<?> getPin() {
        return this.pin;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.updateView();
    }

    public void setNameForLabel(String name) {
        this.label.setName(name);
    }

    public void setBulletAtTheEnd(boolean doOrDoNot) {
        this.label.setHorizontalAlignment(doOrDoNot ? 4 : 2);
        this.label.setHorizontalTextPosition(doOrDoNot ? 2 : 4);
        this.updateView();
    }

    private void updateView() {
        if (this.pin == null) {
            return;
        }
        if (this.selected) {
            this.label.setIcon(this.ioPanelEnabled ? OUTPUT_ON : LOCKED_OUTPUT_ON);
        } else {
            this.label.setIcon(this.ioPanelEnabled ? OUTPUT_OFF : LOCKED_OUTPUT_OFF);
        }
        String previousLabel = this.label.getText();
        String newLabel = HTML.html((String)this.getRenderedName());
        if (!previousLabel.equals(newLabel)) {
            this.label.setText(newLabel);
        }
    }

    public void toggle() {
        this.setSelected(!this.isSelected());
    }

    private String getRenderedName() {
        if (this.pin == null) {
            return "";
        }
        if (this.pin.isInput()) {
            return HTML.fontColor((String)"black", (String)this.getTruncatedLabelText());
        }
        if (this.ioPanelEnabled) {
            return HTML.fontColor((String)"black", (String)this.getTruncatedLabelText());
        }
        return HTML.italic((String)HTML.fontColor((String)"gray", (String)this.getTruncatedLabelText()));
    }

    private String truncate(String s, JLabel label, String truncateSuffix, int maxWidthOfLabel) {
        if (label.getWidth() > 0) {
            FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
            while (fontMetrics.stringWidth(s) > maxWidthOfLabel) {
                int symbolsToCut = truncateSuffix.length() + (s.endsWith(truncateSuffix) ? 1 : 0);
                if (s.length() - symbolsToCut > 0) {
                    s = String.valueOf(s.substring(0, s.length() - symbolsToCut)) + truncateSuffix;
                    continue;
                }
                return truncateSuffix;
            }
        }
        return s;
    }

    private String getTruncatedLabelText() {
        return this.truncate(this.getLabel(), this.label, TRUNCATE_SUFFIX, this.getMaxTextWidth());
    }

    private int getMaxTextWidth() {
        int maxWidth = this.label.getWidth() - this.label.getIcon().getIconWidth() - 10;
        return maxWidth > 0 ? maxWidth : 0;
    }

    public String getLabel() {
        return this.name.toLabel(this.pin);
    }

    @Override
    public void setEnabled(boolean bool) {
        this.ioPanelEnabled = bool;
        this.updateView();
    }

    public void addActionListener(ActionListener actionListener) {
        if (!this.actionListeners.contains(actionListener)) {
            this.actionListeners.add(actionListener);
        }
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.label = new JLabel();
        this.setOpaque(false);
        this.label.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.DEFAULT, URFontFactory.Size.DEFAULT));
        this.label.setHorizontalAlignment(2);
        this.label.setText("IO Name");
        this.label.setPreferredSize(UIManager.getDimension("DigitalNamedIO.dimensions"));
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DigitalNamedIO.this.labelMousePressed();
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label, -2, -1, -2));
    }

    private void labelMousePressed() {
        if (this.ioPanelEnabled) {
            this.toggle();
            for (ActionListener each : this.actionListeners) {
                each.actionPerformed(null);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        this.updateView();
        super.paint(g);
    }
}

