/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.iotab;

import com.ur.lang.StringUtils;
import com.ur.polyscope.pin.ConfigurableIOPin;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.OutputActionPin;
import com.ur.polyscope.pin.ToolIOPin;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.viewfacade.pin.Pin;

public class PinName {
    public String toLabel(Pin<?> pin) {
        String result = "";
        if (pin instanceof ConfigurableIOPin && !pin.isUnassigned()) {
            result = ((ConfigurableIOPin)pin).getShortFunctionName();
        } else if (pin instanceof ToolIOPin && ((ToolIOPin)pin).isSafetyInputPin()) {
            result = ((ToolIOPin)pin).getShortFunctionName();
        } else if (!StringUtils.isNullOrOnlyWhitespace((String)pin.getDefinedName())) {
            result = pin.getDefinedName();
        } else if (pin instanceof InputActionPin && ((InputActionPin)pin).getIOPinAction() != DefaultInputPinAction.INPUT_PIN_ACTION_NONE) {
            result = ((InputActionPin)pin).getIOPinAction().getShortFunctionName();
        } else if (pin instanceof OutputActionPin && ((OutputActionPin)pin).getOutputAction() != OutputPinAction.NONE) {
            result = ((OutputActionPin)pin).getOutputAction().getShortFunctionName();
        } else if (StringUtils.isNullOrOnlyWhitespace((String)result)) {
            result = "" + pin.getPin();
        }
        return result == null ? "" : result;
    }
}

