/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.rtde;

import com.ur.lang.IOUtil;
import com.ur.polyscope.controllerinterface.ControllerSocketListener;
import com.ur.polyscope.controllerinterface.util.ControllerInterfaceSettings;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.pin.rtde.RTDEAsyncListener;
import com.ur.polyscope.pin.rtde.RTDEDataMessage;
import com.ur.polyscope.pin.rtde.RTDEMessage;
import com.ur.polyscope.pin.rtde.RTDEMessageType;
import com.ur.polyscope.pin.rtde.RTDEPauseMessage;
import com.ur.polyscope.pin.rtde.RTDERequestProtocolVersionMessage;
import com.ur.polyscope.pin.rtde.RTDESetupOutputMessage;
import com.ur.polyscope.pin.rtde.RTDEStartMessage;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;
import java.util.concurrent.TimeUnit;

public class RTDEClient {
    private static final Logger LOG = LogFactory.createLogger(RTDEClient.class);
    private static final short RTDE_PROTOCOL_VERSION = 2;
    private static final int IN_HEADER_SIZE = 3;
    private static final int FREQUENCY = 10;
    private boolean isConnected = false;
    private DataOutputStream dataOutputStream;
    private DataInputStream dataInputStream;
    private final RTDEAsyncListener rtdeAsyncListener;
    private Vector<String> configuration = new Vector();
    private boolean paused = false;
    private boolean wasDisconnected = false;

    public RTDEClient(RTDEAsyncListener rtdeAsyncListener) {
        this.rtdeAsyncListener = rtdeAsyncListener;
        ControllerSocketListener controllerSocketListener = connected -> {
            if (connected) {
                this.makeConnection();
            }
        };
        EventNotificationService.register((Object)this, ControllerSocketListener.class, (Object)controllerSocketListener);
    }

    private void makeConnection() {
        if (!this.isConnected) {
            if (this.wasDisconnected) {
                this.wasDisconnected = false;
                Waiting.pause((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            Socket socket = null;
            try {
                socket = new Socket(ControllerInterfaceSettings.getControllerSocketIp(), 30004);
                socket.setTcpNoDelay(true);
                this.dataOutputStream = new DataOutputStream(socket.getOutputStream());
                this.dataInputStream = new DataInputStream(socket.getInputStream());
                this.isConnected = true;
                this.isConnected = this.requestProtocolVersion((short)2);
                if (this.isConnected) {
                    Thread thread = new Thread(this.getReceiver(), "RTDE receiver");
                    thread.setDaemon(true);
                    thread.start();
                    this.configure(this.configuration);
                } else {
                    Log.error((String)"Controller RTDE connection not established");
                    IOUtil.close((Closeable)socket);
                }
            }
            catch (IOException exception) {
                this.isConnected = false;
                LOG.info("Quietly close connection for RTDE: " + exception.getMessage(), new Object[0]);
                IOUtil.close((Closeable)socket);
            }
        }
    }

    public void configure(Vector<String> names) {
        this.configuration = names;
        if (this.isConnected) {
            RTDESetupOutputMessage msg = new RTDESetupOutputMessage(names, 10.0);
            this.sendPause();
            this.send(msg);
            this.sendStart();
        }
    }

    private void pauseStartStop(RTDEMessage msg, boolean newPauseState) {
        if (this.send(msg)) {
            while (this.paused != newPauseState) {
                Waiting.pause((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
    }

    private void sendStart() {
        RTDEStartMessage msg = new RTDEStartMessage();
        this.pauseStartStop(msg, false);
    }

    private void sendPause() {
        RTDEPauseMessage msg = new RTDEPauseMessage();
        this.pauseStartStop(msg, true);
    }

    private Runnable getReceiver() {
        return new ProcessReceivedMessage();
    }

    private ReceivedMessage receive() throws IOException {
        byte[] payload;
        RTDEMessageType type = null;
        try {
            short packageLength = this.dataInputStream.readShort();
            type = RTDEMessageType.getTypeFromId(this.dataInputStream.read());
            int payloadLength = packageLength - 3;
            payload = new byte[payloadLength];
            this.dataInputStream.read(payload, 0, payloadLength);
        }
        catch (IOException e) {
            Log.warning((String)("Problem with message type: " + (type == null ? "Unknown" : type.name())));
            throw e;
        }
        return new ReceivedMessage(type, payload);
    }

    private boolean requestProtocolVersion(short protocolVersion) throws IOException {
        ReceivedMessage reply;
        RTDERequestProtocolVersionMessage msg = new RTDERequestProtocolVersionMessage(protocolVersion);
        this.send(msg);
        while ((reply = this.receive()).getMessageType() != RTDEMessageType.RTDE_REQUEST_PROTOCOL_VERSION && reply.getMessageType() != null) {
        }
        return msg.parseReply(reply.getPayload());
    }

    private boolean send(RTDEMessage msg) {
        boolean messageSend = false;
        if (this.isConnected) {
            try {
                this.dataOutputStream.write(msg.buildMessage());
                this.dataOutputStream.flush();
                messageSend = true;
            }
            catch (IOException e) {
                Log.error((String)("Failed to send message " + (Object)((Object)msg.getMessageType()) + " to controller."), (Throwable)e);
            }
        }
        return messageSend;
    }

    private class ProcessReceivedMessage
    implements Runnable {
        private ProcessReceivedMessage() {
        }

        @Override
        public void run() {
            boolean running = true;
            while (running) {
                try {
                    ReceivedMessage msg = RTDEClient.this.receive();
                    if (msg.getMessageType() == null) break;
                    this.processMessage(msg);
                }
                catch (IOException e) {
                    Log.error((String)"RTDE reception failed", (Throwable)e);
                    RTDEClient.this.wasDisconnected = true;
                    running = false;
                }
            }
            Log.error((String)"RTDE connection closed.");
            IOUtil.close((Closeable)RTDEClient.this.dataOutputStream);
            IOUtil.close((Closeable)RTDEClient.this.dataInputStream);
            RTDEClient.this.isConnected = false;
            RTDEClient.this.paused = false;
        }

        private void processMessage(ReceivedMessage msg) {
            switch (msg.getMessageType()) {
                case RTDE_GET_URCONTROL_VERSION: 
                case RTDE_REQUEST_PROTOCOL_VERSION: 
                case RTDE_TEXT_MESSAGE: 
                case RTDE_CONTROL_PACKAGE_SETUP_INPUTS: {
                    break;
                }
                case RTDE_CONTROL_PACKAGE_START: {
                    RTDEClient.this.paused = false;
                    break;
                }
                case RTDE_CONTROL_PACKAGE_PAUSE: {
                    RTDEClient.this.paused = true;
                    break;
                }
                case RTDE_CONTROL_PACKAGE_SETUP_OUTPUTS: {
                    this.processControlPackageSetupOutputs(msg);
                    break;
                }
                case RTDE_DATA_PACKAGE: {
                    this.processDataPackage(msg);
                }
            }
        }

        private void processControlPackageSetupOutputs(ReceivedMessage msg) {
            RTDESetupOutputMessage rtdeSetupOutputMessage = new RTDESetupOutputMessage();
            rtdeSetupOutputMessage.parseReply(msg.payload);
        }

        private void processDataPackage(ReceivedMessage msg) {
            RTDEDataMessage rtdeDataMessage = new RTDEDataMessage();
            if (rtdeDataMessage.parseReply(msg.payload)) {
                byte[] data = rtdeDataMessage.getData();
                RTDEClient.this.rtdeAsyncListener.handleMessage(data);
            }
        }
    }

    private static class ReceivedMessage {
        private final RTDEMessageType type;
        private final byte[] payload;

        ReceivedMessage(RTDEMessageType type, byte[] payload) {
            this.type = type;
            this.payload = payload;
        }

        public byte[] getPayload() {
            return this.payload;
        }

        RTDEMessageType getMessageType() {
            return this.type;
        }
    }
}

