/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.rtde;

import com.ur.lang.StringUtils;
import com.ur.polyscope.pin.GeneralPurposeRegisterListener;
import com.ur.polyscope.pin.rtde.RTDESubscriber;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import java.util.ArrayList;
import java.util.Arrays;

public class RTDEGeneralPurposeBooleanRegisterSubscriber
implements RTDESubscriber {
    static final int MESSAGE_SIZE_BYTES = 72;
    private final boolean[] booleans31 = new boolean[32];
    private final boolean[] booleans63 = new boolean[32];
    private final boolean[] booleans = new boolean[128];
    private final boolean[] outputRegisters = new boolean[0];
    private NotificationStrategy<GeneralPurposeRegisterListener.Boolean> notificationHandler = new NotificationStrategy<GeneralPurposeRegisterListener.Boolean>(){

        public void notify(GeneralPurposeRegisterListener.Boolean listener) {
            listener.updateBooleanRegisters(RTDEGeneralPurposeBooleanRegisterSubscriber.this.booleans, RTDEGeneralPurposeBooleanRegisterSubscriber.this.outputRegisters);
        }
    };

    @Override
    public void handleMessage(byte[] bytes) {
        this.toBooleans(this.booleans31, Arrays.copyOfRange(bytes, 0, 4));
        this.toBooleans(this.booleans63, Arrays.copyOfRange(bytes, 4, 8));
        this.mergeArrays(this.booleans, this.booleans31, this.booleans63);
        int bytesIdx = 8;
        int i = 64;
        while (i < 128) {
            this.booleans[i] = bytes[bytesIdx] != 0;
            ++bytesIdx;
            ++i;
        }
        EventNotificationService.notify(GeneralPurposeRegisterListener.Boolean.class, this.notificationHandler);
    }

    private void mergeArrays(boolean[] dest, boolean[] b1, boolean[] b2) {
        System.arraycopy(b1, 0, dest, 0, b1.length);
        System.arraycopy(b2, 0, dest, b1.length, b2.length);
    }

    private void toBooleans(boolean[] dest, byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            dest[i * 8] = (bytes[bytes.length - i - 1] & 1) != 0;
            dest[i * 8 + 1] = (bytes[bytes.length - i - 1] & 2) != 0;
            dest[i * 8 + 2] = (bytes[bytes.length - i - 1] & 4) != 0;
            dest[i * 8 + 3] = (bytes[bytes.length - i - 1] & 8) != 0;
            dest[i * 8 + 4] = (bytes[bytes.length - i - 1] & 0x10) != 0;
            dest[i * 8 + 5] = (bytes[bytes.length - i - 1] & 0x20) != 0;
            dest[i * 8 + 6] = (bytes[bytes.length - i - 1] & 0x40) != 0;
            dest[i * 8 + 7] = (bytes[bytes.length - i - 1] & 0x80) != 0;
            ++i;
        }
    }

    @Override
    public String getRTDESetupMessage() {
        ArrayList<String> registers = new ArrayList<String>();
        registers.add("input_bit_registers0_to_31");
        registers.add("input_bit_registers32_to_63");
        int i = 64;
        while (i < 128) {
            registers.add("input_bit_register_" + i);
            ++i;
        }
        return StringUtils.joinStringsWith((String)",", (Object[])registers.toArray());
    }

    @Override
    public int getMessageSize() {
        return 72;
    }
}

