/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.rtde;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageConsumer;
import com.ur.view.constants.errorcodes.ReportLevel;
import java.io.DataInput;
import java.io.IOException;

public class RTDEMessageConsumer
implements RobotMessageConsumer {
    public boolean sendNotification() {
        return true;
    }

    public int consume(DataInput dataInputStream, int messageLength, RobotMessage robotMessage) throws IOException {
        int messageOffset = 0;
        int[] offset = new int[]{messageOffset};
        robotMessage.message = RTDEMessageConsumer.readShortString(dataInputStream, offset);
        robotMessage.rtdeMessageSource = RTDEMessageConsumer.readShortString(dataInputStream, offset);
        messageOffset = offset[0];
        robotMessage.warningLevel = ReportLevel.byId((int)dataInputStream.readUnsignedByte());
        return messageOffset + 1;
    }

    private static String readShortString(DataInput dataInputStream, int[] offset) throws IOException {
        int contentLength = dataInputStream.readUnsignedByte();
        offset[0] = offset[0] + 1;
        byte[] contentData = new byte[contentLength];
        dataInputStream.readFully(contentData, 0, contentLength);
        offset[0] = offset[0] + contentLength;
        return new String(contentData);
    }
}

