/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.rtde;

import com.ur.polyscope.pin.rtde.RTDEAsyncListener;
import com.ur.polyscope.pin.rtde.RTDEClient;
import com.ur.polyscope.pin.rtde.RTDESubscriber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.inject.Inject;

public class RTDEPublisher
implements RTDEAsyncListener {
    private final List<RTDESubscriber> subscribers = new ArrayList<RTDESubscriber>();
    private final RTDEClient rtdeClient = new RTDEClient(this);

    @Inject
    public RTDEPublisher() {
    }

    private Vector<String> generateSetupMessages() {
        Vector<String> setupMessages = new Vector<String>();
        for (RTDESubscriber subscriber : this.subscribers) {
            setupMessages.add(subscriber.getRTDESetupMessage());
        }
        return setupMessages;
    }

    @Override
    public void handleMessage(byte[] bytes) {
        int offset = 0;
        for (RTDESubscriber subscriber : this.subscribers) {
            int messageSize = subscriber.getMessageSize();
            byte[] message = Arrays.copyOfRange(bytes, offset, offset + messageSize);
            offset += messageSize;
            subscriber.handleMessage(message);
        }
    }

    public void addSubscribers(Set<RTDESubscriber> subscribers) {
        this.subscribers.addAll(subscribers);
        this.rtdeClient.configure(this.generateSetupMessages());
    }
}

