/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.service;

import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.pin.service.CustomIOService;
import com.ur.polyscope.pin.service.IOInterface;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.pin.IOServiceType;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.util.Predicate;
import java.util.List;
import java.util.Set;

public interface IOService
extends CustomIOService,
InstallationComponent {
    public static final int NUMBER_OF_IO_DIGITAL_PORTS = 8;
    public static final int NUMBER_OF_TOOL_DIGITAL_IO = 2;
    public static final int NUMBER_OF_CONFIGURABLE_DIGITAL_IO = 8;
    public static final int NUMBER_OF_TOOL_ANALOG_INPUTS = 2;
    public static final int NUMBER_OF_STANDARD_ANALOG_INPUTS = 2;
    public static final int NUMBER_OF_STANDARD_ANALOG_OUTPUTS = 2;
    public static final int NUMBER_OF_GENERAL_PURPOSE_BOOLEAN_REGISTERS = 128;
    public static final int NUMBER_OF_GENERAL_PURPOSE_INT_REGISTERS = 48;
    public static final int NUMBER_OF_GENERAL_PURPOSE_FLOAT_REGISTERS = 48;
    public static final int NUMBER_OF_ALL_DIGITAL_OUTPUTS = 18;
    public static final int NUMBER_OF_ALL_DIGITAL_INPUTS = 18;
    public static final int NUMBER_OF_ALL_ANALOG_INPUTS = 4;

    public void setComponent(IOInterface var1);

    public Register<?>[] getGeneralPurposeBooleanInputRegisters();

    public Register<?>[] getGeneralPurposeBooleanOutputRegisters();

    public Register<?>[] getGeneralPurposeIntInputRegisters();

    public Register<?>[] getGeneralPurposeIntOutputRegisters();

    public Register<?>[] getGeneralPurposeFloatInputRegisters();

    public Register<?>[] getGeneralPurposeFloatOutputRegisters();

    public Pin<?>[] getStandardDigitalOutputPins();

    public Pin<?>[] getToolDigitalOutputPins();

    public Pin<?>[] getStandardAnalogOutputPins();

    public Pin<?>[] getStandardDigitalInputPins();

    public Pin<?>[] getToolDigitalInputPins();

    public Pin<?>[] getAllAnalogInputPins();

    public Pin<?>[] getStandardAnalogInputPins();

    public Pin<?>[] getToolAnalogInputPins();

    public Pin<?>[] getConfigurableDigitalOutputPins();

    public Pin<?>[] getConfigurableDigitalInputPins();

    public Set<NamedEntity> getAllUserDefinedPins();

    public List<Pin<?>> getOutputs(IOInterfaceType var1, IOSignalType var2);

    public List<Pin<?>> getInputs(IOInterfaceType var1, IOSignalType var2);

    public List<Pin<?>> getAllOutputs();

    public List<Pin<?>> getAllInputs();

    public Pin<?> getPinWithName(String var1);

    public Predicate<Pin<?>> getToolCommEnabledPredicate(boolean var1);

    public void resetOutputActions();

    public void resetPinNamesAndActions();

    public ScriptWriter appendSetRunstateOutputs(ScriptWriter var1);

    public int getAnalogInputRange(int var1);

    public int getAnalogOutputDomain(int var1);

    public void setAnalogInputRange(int[] var1);

    public void setAnalogOutputDomain(int[] var1);

    public int[] getAnalogInputRange();

    public int[] getAnalogOutputDomain();

    public void setAnalogInputRange(int var1, int var2);

    public void setAnalogOutputDomain(int var1, int var2);

    public static enum IOInterfaceType {
        ALL,
        STANDARD,
        TOOL,
        CONFIGURABLE,
        MODBUS,
        GENERAL_PURPOSE,
        IMMI;

    }

    public static enum IOSignalType {
        ALL,
        DIGITAL,
        ANALOG,
        TOOL,
        Configurable,
        Boolean,
        Integer,
        Float,
        MODBUS,
        IMMI;

    }

    public static class IsOutput
    implements Predicate<Pin<?>> {
        public boolean test(Pin<?> pin) {
            return !pin.isInput();
        }
    }

    public static class OfType
    implements Predicate<Pin<?>> {
        private final IOServiceType type;

        public OfType(IOServiceType type) {
            this.type = type;
        }

        public boolean test(Pin<?> o) {
            return o.getValueType() == this.type;
        }
    }

    public static class Unassigned
    implements Predicate<Pin<?>> {
        public boolean test(Pin<?> pin) {
            return pin.isUnassigned();
        }
    }

    public static class UnassignedOfType
    implements Predicate<Pin<?>> {
        private final IOServiceType pinValueType;

        public UnassignedOfType(IOServiceType pinValueType) {
            this.pinValueType = pinValueType;
        }

        public boolean test(Pin<?> pin) {
            return pin.getValueType() == this.pinValueType && pin.isUnassigned();
        }
    }

    public static class WithUserDefinedName
    implements Predicate<Pin<?>> {
        public boolean test(Pin<?> pin) {
            return !StringUtils.isNullOrOnlyWhitespace((String)pin.getDefinedName());
        }
    }
}

