/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pin.urcaps;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.pin.OutputActionPin;
import com.ur.polyscope.pin.ResolvablePin;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.scriptwriter.IOScriptGenerator;
import com.ur.polyscope.urcaps.extensions.io.IOextension;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.urcap.api.domain.io.IO;

public abstract class IOImpl
implements IOextension,
IOScriptGenerator {
    protected Pin<?> ioPin;
    protected IO.IOType ioType;
    protected IO.InterfaceType interfaceType;

    public IOImpl(Pin<?> ioPin, IO.IOType ioType, IO.InterfaceType interfaceType) {
        this.ioPin = ioPin;
        this.ioType = ioType;
        this.interfaceType = interfaceType;
    }

    public boolean isInput() {
        return this.ioPin.isInput();
    }

    public IO.IOType getType() {
        return this.ioType;
    }

    public IO.InterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    public String getName() {
        return this.ioPin.getName();
    }

    public int hashCode() {
        return this.ioPin.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IOImpl)) {
            return false;
        }
        IOImpl other = (IOImpl)obj;
        return EqualsUtil.equals(this.ioPin, other.ioPin);
    }

    public Pin<?> getIOPin() {
        return this.ioPin;
    }

    public String toString() {
        String name = this.ioPin.getUserDefinedName();
        if (name == null || name.trim().length() == 0) {
            name = this.ioPin.getDefaultName();
        }
        return name;
    }

    public String getDefaultName() {
        return this.getIOPin().getDefaultName();
    }

    public String getValueStr() {
        Object value = this.getIOPin().getValue();
        return value == null ? "" : value.toString();
    }

    public boolean isResolvable() {
        if (this.ioPin instanceof ResolvablePin) {
            return ((ResolvablePin)this.ioPin).isResolvable();
        }
        return true;
    }

    public void setOutputIOAction(IOextension.OutputAction outputIOAction) {
        if (!this.isInput() && this.getIOPin() instanceof OutputActionPin) {
            OutputActionPin outputActionPin = (OutputActionPin)this.getIOPin();
            outputActionPin.setOutputAction(this.convertToPolyScopeOutputAction(outputIOAction));
        }
    }

    public IOextension.OutputAction getOutputIOAction() {
        OutputActionPin outputActionPin;
        OutputPinAction outputAction;
        if (!this.isInput() && this.getIOPin() instanceof OutputActionPin && (outputAction = (outputActionPin = (OutputActionPin)this.getIOPin()).getOutputAction()) != null) {
            return this.convertToURCapOutputAction(outputAction);
        }
        return IOextension.OutputAction.NONE;
    }

    private OutputPinAction convertToPolyScopeOutputAction(IOextension.OutputAction action) {
        switch (action) {
            case LOW_WHEN_PROGRAM_STOPPED: {
                return OutputPinAction.LOW_WHEN_PROGRAM_STOPPED;
            }
            case NONE: {
                return OutputPinAction.NONE;
            }
            case HIGH_WHEN_PROGRAM_STOPPED: {
                return OutputPinAction.HIGH_WHEN_PROGRAM_STOPPED;
            }
            case PROGRAM_RUNNING: {
                return OutputPinAction.PROGRAM_RUNNING;
            }
            case POWERED_PIN_0: {
                return OutputPinAction.POWERED_PIN_0;
            }
            case POWERED_PIN_1: {
                return OutputPinAction.POWERED_PIN_1;
            }
            case CONTINUOUS_PULSE: {
                return OutputPinAction.CONTINUOUS_PULSE;
            }
        }
        return OutputPinAction.NONE;
    }

    private IOextension.OutputAction convertToURCapOutputAction(OutputPinAction outputPinAction) {
        switch (outputPinAction) {
            case LOW_WHEN_PROGRAM_STOPPED: {
                return IOextension.OutputAction.LOW_WHEN_PROGRAM_STOPPED;
            }
            case NONE: {
                return IOextension.OutputAction.NONE;
            }
            case HIGH_WHEN_PROGRAM_STOPPED: {
                return IOextension.OutputAction.HIGH_WHEN_PROGRAM_STOPPED;
            }
            case PROGRAM_RUNNING: {
                return IOextension.OutputAction.PROGRAM_RUNNING;
            }
            case POWERED_PIN_0: {
                return IOextension.OutputAction.POWERED_PIN_0;
            }
            case POWERED_PIN_1: {
                return IOextension.OutputAction.POWERED_PIN_1;
            }
            case CONTINUOUS_PULSE: {
                return IOextension.OutputAction.CONTINUOUS_PULSE;
            }
        }
        return IOextension.OutputAction.NONE;
    }

    public String generateGetValueScript() {
        this.assertResolvable();
        return this.ioPin.generateGetterScriptCode();
    }

    public String generateSetValueScript(Object o) {
        this.assertResolvable();
        String value = this.convertToScriptValue(o);
        return this.ioPin.generateSetterScriptCode(value);
    }

    protected abstract String convertToScriptValue(Object var1);

    private void assertResolvable() {
        if (!this.isResolvable()) {
            throw new IllegalArgumentException("The io " + this.getName() + " is not resolvable");
        }
    }

    protected void assertIsOutput() {
        if (this.isInput()) {
            throw new IllegalArgumentException("The io " + this.getName() + "  must be output.");
        }
    }
}

