/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.api.contribution.installation.configuration.safety;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.AtomicReference;

public final class ReadOnceSeed
implements Externalizable {
    private static final String LETTERS_OR_NUMBERS = "[a-zA-Z0-9]*";
    private static final String AT_LEAST_ONE_DIGIT_AND_ONE_LOWER_AND_UPPER_CASE_LETTER = "(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).*";
    private static final int MINIMUM_LENGTH = 10;
    private static final int MAXIMUM_LENGTH = 100;
    private final AtomicReference<String> value;

    public ReadOnceSeed(String seed) {
        if (seed == null) {
            throw new IllegalArgumentException("seed cannot be null");
        }
        this.validateLength(seed);
        this.validateContent(seed);
        this.value = new AtomicReference<String>(seed);
    }

    public String value() {
        return this.seedOrThrow(this.value.getAndSet(null));
    }

    private String seedOrThrow(String seed) {
        if (seed == null) {
            throw new IllegalStateException("Sensitive seed has already been consumed");
        }
        return seed;
    }

    private void validateLength(String seed) {
        if (seed.length() < 10 || seed.length() > 100) {
            throw new IllegalArgumentException("seed length must be between 10 and 100 characters");
        }
    }

    private void validateContent(String seed) {
        if (!seed.matches(LETTERS_OR_NUMBERS)) {
            throw new IllegalArgumentException("seed must only consist of letters and/or numbers (a-z, A-Z, 0-9)");
        }
        if (!seed.matches(AT_LEAST_ONE_DIGIT_AND_ONE_LOWER_AND_UPPER_CASE_LETTER)) {
            throw new IllegalArgumentException("seed must contain at least one digit, one upper case letter and one lower case letter");
        }
    }

    public String toString() {
        return "SensitiveValue{value=*****}";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ReadOnceSeed.deny();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ReadOnceSeed.deny();
    }

    private static void deny() {
        throw new UnsupportedOperationException("Not allowed on Seed. Sensitive data.");
    }
}

