/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.api.contribution.installation.configuration.safety;

import java.util.Objects;

public final class SafetyChecksum {
    private static final long MIN_VALUE = 0L;
    private static final long MAX_VALUE = 0xFFFFFFFFL;
    private final long checksum;

    public SafetyChecksum(String hashAsString) {
        this(Long.parseLong(hashAsString));
    }

    public SafetyChecksum(long checksum) {
        SafetyChecksum.isValidChecksum(checksum);
        this.checksum = checksum;
    }

    public long asLong() {
        return this.checksum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SafetyChecksum that = (SafetyChecksum)o;
        return this.checksum == that.checksum;
    }

    public int hashCode() {
        return Objects.hash(this.checksum);
    }

    private static void isValidChecksum(long checksum) {
        if (checksum < 0L || checksum > 0xFFFFFFFFL) {
            String message = "Checksum must be between 0 and 4,294,967,295, but was " + checksum;
            throw new IllegalArgumentException(message);
        }
    }
}

