/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal;

import com.ur.disk.Directories;
import com.ur.polyscope.controllerinterface.ControllerServiceListener;
import com.ur.polyscope.controllerinterface.ControllerServiceManager;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.util.commandline.BashScriptRunner;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import java.io.File;
import javax.inject.Inject;

public class ControllerServiceManagerImpl
implements ControllerServiceManager {
    private static final Logger LOG = LogFactory.createLogger(ControllerServiceManagerImpl.class);
    private static final String START_URCONTROL = "starturcontrol.sh";
    private static final String STOP_URCONTROL = "stopurcontrol.sh";
    private final ScriptRunnerGenerator generator;

    @Inject
    public ControllerServiceManagerImpl(ScriptRunnerGenerator generator) {
        this.generator = generator;
    }

    public void startService() {
        this.inForeground(this.generator.makeScriptRunner(START_URCONTROL));
    }

    public void stopService() {
        this.notifyDisconnect();
        this.inForeground(this.generator.makeScriptRunner(STOP_URCONTROL));
    }

    void notifyDisconnect() {
        EventNotificationService.notify(ControllerServiceListener.class, (NotificationStrategy)new NotificationStrategy<ControllerServiceListener>(){

            public void notify(ControllerServiceListener controllerServiceListener) {
                controllerServiceListener.beforeDisconnect();
            }
        });
    }

    void inForeground(BashScriptRunner bsr) {
        LOG.debug("Executing bash command: " + bsr, new Object[0]);
        try {
            bsr.execute();
        }
        catch (Exception e) {
            LOG.error("Unable to run script: " + bsr, (Throwable)e);
        }
    }

    static class ScriptRunnerGenerator {
        ScriptRunnerGenerator() {
        }

        public BashScriptRunner makeScriptRunner(String scriptFile) {
            File stopControllerScript = new File(Directories.home(), scriptFile);
            return new BashScriptRunner(stopControllerScript.getAbsolutePath());
        }
    }
}

