/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal;

import com.ur.lang.Defense;
import com.ur.lang.EqualsUtil;
import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.ControllerConnectionListener;
import com.ur.polyscope.controllerinterface.ControllerSocketListener;
import com.ur.polyscope.controllerinterface.MessageConsumer;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.polyscope.controllerinterface.internal.HMCInterfaceImpl;
import com.ur.polyscope.controllerinterface.internal.HMCResponseImpl;
import com.ur.polyscope.controllerinterface.synchroneous.HMCResponse;
import com.ur.polyscope.controllerinterface.util.ControllerInterfaceSettings;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.comm.MessageType;
import com.ur.view.constants.comm.RobotStatePackageType;
import com.ur.view.constants.dev.RobotMode;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

@Deprecated
public final class ControllerSocket {
    private static final Logger LOG = LogFactory.createLogger(ControllerSocket.class);
    private static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;
    private static final EnumSet<RobotStatePackageType> loggedUnknownType = EnumSet.noneOf(RobotStatePackageType.class);
    private static final RobotState robotStateToEditHere = new RobotState(true);
    private static final Map<MessageType, MessageConsumer> messageConsumers = new EnumMap<MessageType, MessageConsumer>(MessageType.class);
    private static final Map<RobotStatePackageType, RobotStatePackageConsumer> robotStatePackageConsumers = new EnumMap<RobotStatePackageType, RobotStatePackageConsumer>(RobotStatePackageType.class);
    private static final Map<Integer, HMCInterfaceImpl.HMCMessageListener> hmcListenersById = new ConcurrentHashMap<Integer, HMCInterfaceImpl.HMCMessageListener>();
    private static boolean suppressWritesInTesting;
    private static volatile Socket socket;
    private static volatile DataOutputStream dataOutputStream;
    private static volatile DataInputStream dataInputStream;
    private static int prevMessageType;
    private static boolean wasInitialized;
    private static boolean wasStarted;
    private static boolean disconnecting;

    private ControllerSocket() {
    }

    static synchronized void initialize(Set<MessageConsumer> messageConsumerSet, Set<RobotStatePackageConsumer> robotStatePackageConsumerSet) {
        if (!wasInitialized) {
            for (MessageConsumer messageConsumer : messageConsumerSet) {
                messageConsumer.initialize(robotStateToEditHere);
                messageConsumers.put((MessageType)messageConsumer.getPackageType(), messageConsumer);
            }
            for (RobotStatePackageConsumer robotStatePackageConsumer : robotStatePackageConsumerSet) {
                robotStatePackageConsumer.initialize(robotStateToEditHere);
                robotStatePackageConsumers.put((RobotStatePackageType)robotStatePackageConsumer.getPackageType(), robotStatePackageConsumer);
            }
            wasInitialized = true;
        }
    }

    static synchronized void startConnectionThread() {
        if (!wasStarted) {
            try {
                new ConnectionThread().start();
                wasStarted = true;
            }
            catch (Exception e) {
                LOG.error("Unable to start connection", (Throwable)e);
            }
        }
    }

    static boolean isConnected() {
        if (suppressWritesInTesting) {
            return true;
        }
        if (socket == null) {
            return false;
        }
        return socket.isConnected();
    }

    static synchronized void disconnect() {
        block11: {
            try {
                disconnecting = true;
                if (socket != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        dataOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                    break block11;
                }
                if (!suppressWritesInTesting) {
                    LOG.error("Called when socket is null", (Throwable)new IllegalStateException());
                }
            }
            finally {
                LOG.info("GUI disconnected from controller", new Object[0]);
                ControllerSocket.robotStateToEditHere.robotMode = RobotMode.NO_CONTROLLER;
                ControllerSocket.robotStateToEditHere.real = false;
                socket = null;
                dataInputStream = null;
                dataOutputStream = null;
                ControllerSocket.notifyAllSubscribers(false);
                disconnecting = false;
            }
        }
        Waiting.pause((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    static void registerHMCMessageListener(int messageId, HMCInterfaceImpl.HMCMessageListener listener) {
        Defense.notNull((Object)listener);
        hmcListenersById.put(messageId, listener);
    }

    static void unregisterHMCMessageListener(int messageId) {
        hmcListenersById.remove(messageId);
    }

    private static void notifyAllSubscribers(boolean connected) {
        EventNotificationService.notify(ControllerSocketListener.class, controllerSocketListener -> controllerSocketListener.socketEvent(connected));
    }

    static synchronized boolean writeBytes(String s) {
        if (suppressWritesInTesting) {
            if (dataOutputStream != null) {
                return ControllerSocket.doWriteBytes(s);
            }
            return false;
        }
        if (!ControllerSocket.isConnected()) {
            LOG.warn("Not connected to controller, trying to send string: \n" + s, new Object[0]);
            return false;
        }
        return ControllerSocket.doWriteBytes(s);
    }

    private static boolean doWriteBytes(String s) {
        try {
            LOG.traceRoute((Object)("ControllerSocket[program=\"" + ControllerSocket.stripLinesToMaximum(s) + "\"]"));
            byte[] bytes = s.getBytes(CHARSET_UTF8);
            dataOutputStream.write(bytes);
            dataOutputStream.flush();
            return true;
        }
        catch (Exception e) {
            if (s.length() > 60) {
                s = s.substring(0, 60);
            }
            LOG.error("Could not send string to controller. Max. 60 characters: \"" + s + "\"", (Throwable)e);
            return false;
        }
    }

    private static String stripLinesToMaximum(String input) {
        String[] lines = input.split("\n");
        StringBuilder sb = new StringBuilder();
        int numLines = Math.min(lines.length, 4);
        for (int i = 0; i < numLines; ++i) {
            sb.append(lines[i] + "\n");
        }
        return sb.toString();
    }

    static boolean isControllerAvailable() {
        return !EqualsUtil.equalsOneOf((Object)ControllerSocket.robotStateToEditHere.robotMode, (Object[])new RobotMode[]{RobotMode.NO_CONTROLLER, RobotMode.DISCONNECTED, RobotMode.UPDATING});
    }

    static void setSuppressWrites(boolean suppressWritesState) {
        suppressWritesInTesting = suppressWritesState;
    }

    static StringBuilder forTestingSetStringOutputStream() {
        final StringBuilder result = new StringBuilder();
        dataOutputStream = new DataOutputStream(new OutputStream(){

            @Override
            public void write(byte[] b) {
                result.append(new String(b, StandardCharsets.UTF_8));
            }

            @Override
            public void write(byte[] b, int off, int len) {
                result.append(new String(b, off, len, StandardCharsets.UTF_8));
            }

            @Override
            public void write(int b) {
                byte[] bytes = new byte[]{(byte)b};
                result.append(new String(bytes, StandardCharsets.UTF_8));
            }

            public String toString() {
                return result.toString();
            }
        });
        return result;
    }

    static {
        prevMessageType = -1;
        wasInitialized = false;
        wasStarted = false;
        disconnecting = false;
    }

    private static class ConnectionThread
    extends Thread {
        ConnectionThread() {
            super("ControllerConnectionThread");
        }

        private static void connect() {
            int interleave = 0;
            while (!ControllerSocket.isConnected()) {
                try {
                    Thread.sleep(100L);
                    robotStateToEditHere.hasReceivedPositionData = false;
                    robotStateToEditHere.notifyAllSubscribers();
                    if (++interleave < 10) continue;
                    interleave = 0;
                    socket = new Socket();
                    InetSocketAddress isa = new InetSocketAddress(ControllerInterfaceSettings.getControllerSocketIp(), ControllerInterfaceSettings.getControllerPort());
                    socket.connect(isa);
                    socket.setTcpNoDelay(true);
                    dataOutputStream = new DataOutputStream(socket.getOutputStream());
                    dataInputStream = new DataInputStream(socket.getInputStream());
                    LOG.info("GUI connected to controller", new Object[0]);
                    robotStateToEditHere.robotMode = RobotMode.NO_CONTROLLER;
                    robotStateToEditHere.setCurrentProgramName("");
                    ControllerSocket.notifyAllSubscribers(true);
                }
                catch (ConnectException isa) {
                }
                catch (Exception e) {
                    LOG.error("ControllerSocket.connect() Error: Exception during connect: ", (Throwable)e);
                }
            }
        }

        private static void parseMessage() throws IOException {
            if (suppressWritesInTesting) {
                return;
            }
            int messageOffset = 0;
            int messageLength = dataInputStream.readInt();
            messageOffset += 4;
            int messageTypeAsInt = dataInputStream.read();
            ++messageOffset;
            MessageType messageType = MessageType.byId((int)messageTypeAsInt);
            messageOffset = ConnectionThread.handleMessageType(messageType, messageOffset, messageLength, messageTypeAsInt);
            ConnectionThread.handleMessageLengthAndOffsetDifference(messageLength, messageOffset, messageType);
            prevMessageType = messageTypeAsInt;
        }

        private static int handleMessageType(MessageType messageType, int messageOffset, int messageLength, int messageTypeAsInt) throws IOException {
            switch (messageType) {
                case DISCONNECT: {
                    ControllerSocket.disconnect();
                    return messageOffset;
                }
                case ROBOT_STATE: {
                    return ConnectionThread.parseMessageRobotState(messageOffset, messageLength);
                }
                case HMC_MESSAGE: {
                    return ConnectionThread.parseMessageHMCMessage(messageOffset, messageLength);
                }
            }
            return ConnectionThread.parseDefaultMessage(messageType, messageOffset, messageLength, messageTypeAsInt);
        }

        private static int parseDefaultMessage(MessageType messageType, int messageOffset, int messageLength, int messageTypeAsInt) throws IOException {
            if (messageConsumers.containsKey(messageType)) {
                messageOffset += ((MessageConsumer)messageConsumers.get(messageType)).consume((DataInput)dataInputStream, messageLength - messageOffset);
            } else {
                ConnectionThread.handleUnknownMessageType(messageType, messageOffset, messageLength, messageTypeAsInt);
            }
            return messageOffset;
        }

        private static void handleUnknownMessageType(MessageType messageType, int messageOffset, int messageLength, int messageTypeAsInt) throws IOException {
            String s = "Unknown message type " + messageType + ":" + messageTypeAsInt + " of length " + messageLength + ", offset " + messageOffset + " (previous message type was " + prevMessageType + ")";
            LOG.error(s, new Object[0]);
            dataInputStream.skipBytes(messageLength - messageOffset);
            throw new RuntimeException(s);
        }

        private static void handleMessageLengthAndOffsetDifference(int messageLength, int messageOffset, MessageType messageType) throws IOException {
            if (messageLength != messageOffset) {
                LOG.error("MessageType type " + messageType + " had length " + messageOffset + " but was expected to have length " + messageLength, new Object[0]);
                ConnectionThread.handleLengthAndOffsetError(messageLength, messageOffset, messageType);
            }
        }

        private static void handleLengthAndOffsetError(int messageLength, int messageOffset, MessageType messageType) throws IOException {
            ConnectionThread.skipAdditionalBytes(messageLength, messageOffset, messageType);
            ConnectionThread.logIfParsedMoreBytesThanMessageLength(messageLength, messageOffset, messageType);
        }

        private static void skipAdditionalBytes(int messageLength, int messageOffset, MessageType messageType) throws IOException {
            if (messageOffset < messageLength && Objects.nonNull(dataInputStream)) {
                LOG.error(String.format("MessageType type %s is parsing fewer bytes than message length", messageType), new Object[0]);
                dataInputStream.skipBytes(messageLength - messageOffset);
            }
        }

        private static void logIfParsedMoreBytesThanMessageLength(int messageLength, int messageOffset, MessageType messageType) {
            if (messageOffset > messageLength) {
                LOG.error(String.format("MessageType type %s is parsing more than message length", messageType), new Object[0]);
            }
        }

        private static int parseMessageRobotState(int messageOffset, int messageLength) throws IOException {
            while (messageOffset < messageLength) {
                int packageStart = messageOffset;
                int packageLength = dataInputStream.readInt();
                messageOffset += 4;
                int packageTypeId = dataInputStream.read();
                ++messageOffset;
                RobotStatePackageType packageType = RobotStatePackageType.byId((int)packageTypeId);
                if (packageType == RobotStatePackageType.NEEDED_FOR_CALIB_DATA) {
                    dataInputStream.skipBytes(packageLength - 5);
                    messageOffset += packageLength - 5;
                } else if (robotStatePackageConsumers.containsKey(packageType)) {
                    messageOffset += ((RobotStatePackageConsumer)robotStatePackageConsumers.get(packageType)).consume((DataInput)dataInputStream, messageLength - messageOffset);
                } else {
                    ConnectionThread.logUnknownPackageType(packageType);
                    dataInputStream.skipBytes(packageLength - 5);
                    messageOffset += packageLength - 5;
                }
                if (packageLength + packageStart != messageOffset) {
                    LOG.error("Robot state, Package type " + packageType + " had length " + packageLength + " but was expected to have length " + (messageOffset - packageStart), new Object[0]);
                    if (packageLength + packageStart < messageOffset) {
                        dataInputStream.skipBytes(messageOffset - packageLength - packageStart);
                        messageOffset = packageStart + packageLength;
                        continue;
                    }
                    LOG.error("Robot state, Package type " + packageType + " parsing more than package length", new Object[0]);
                    continue;
                }
                if (messageOffset <= messageLength + 1) continue;
                LOG.error("Error in calculation of message offset, probably error on controller side!", new Object[0]);
            }
            robotStateToEditHere.notifyAllSubscribers();
            return messageOffset;
        }

        private static int parseMessageHMCMessage(int messageOffset, int messageLength) {
            try {
                int read;
                int id = dataInputStream.readInt();
                messageOffset += 4;
                byte[] buffer = new byte[messageLength - 9];
                for (read = 0; read < messageLength - 9; read += dataInputStream.read(buffer, read, messageLength - 9 - read)) {
                }
                messageOffset += read;
                HMCResponseImpl hmcResponse = new HMCResponseImpl(id, buffer);
                ConnectionThread.deliverHMCMessage(hmcResponse);
            }
            catch (Exception e) {
                LOG.error("HMC Read message failed: ", (Throwable)e);
            }
            return messageOffset;
        }

        private static void deliverHMCMessage(HMCResponse message) {
            if (hmcListenersById.containsKey(message.getMessageId())) {
                ((HMCInterfaceImpl.HMCMessageListener)hmcListenersById.get(message.getMessageId())).deliverMessage(message);
            } else {
                LOG.debug("Unable to deliver HMC Response with id " + message.getMessageId(), new Object[0]);
            }
        }

        private static void logUnknownPackageType(RobotStatePackageType packageType) {
            if (!loggedUnknownType.contains(packageType)) {
                LOG.error("Unsupported RobotState package type: " + packageType, new Object[0]);
                loggedUnknownType.add(packageType);
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    robotStateToEditHere.robotMode = RobotMode.NO_CONTROLLER;
                    ConnectionThread.connect();
                    Runnable doWorkRunnableConnected = () -> EventNotificationService.notify(ControllerConnectionListener.class, ControllerConnectionListener::connectedToController);
                    SwingUtilities.invokeLater(doWorkRunnableConnected);
                    this.performWhileConnected();
                    Runnable doWorkRunnableDisconnected = () -> {
                        EventNotificationService.notify(ControllerConnectionListener.class, ControllerConnectionListener::disconnectedFromController);
                        ControllerSocket.notifyAllSubscribers(false);
                    };
                    SwingUtilities.invokeLater(doWorkRunnableDisconnected);
                    Waiting.pause((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                LOG.error("Disconnected and failed: ", (Throwable)e);
                return;
            }
        }

        private void performWhileConnected() {
            while (ControllerSocket.isConnected()) {
                try {
                    Thread.yield();
                    ConnectionThread.parseMessage();
                }
                catch (IOException e) {
                    if (disconnecting) continue;
                    LOG.error("ControllerSocket: Error in TCP/IP stream; ", (Throwable)e);
                    ControllerSocket.disconnect();
                }
            }
        }
    }
}

