/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal;

import com.ur.polyscope.controllerinterface.ControllerServiceListener;
import com.ur.polyscope.controllerinterface.ControllerSocketListener;
import com.ur.polyscope.flightrecorder.FlightRecorder;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FlightRecordTriggerOnControllerDisconnect
implements ControllerSocketListener,
ControllerServiceListener {
    private boolean shouldGenerate = true;
    private FlightRecorder flightRecorder;

    @Inject
    public FlightRecordTriggerOnControllerDisconnect(FlightRecorder flightRecorder) {
        this.flightRecorder = flightRecorder;
        EventNotificationService.register(null, ControllerSocketListener.class, (Object)this);
        EventNotificationService.register(null, ControllerServiceListener.class, (Object)this);
    }

    public void beforeDisconnect() {
        Log.debug((String)"Controller disconnecting on purpose");
        this.shouldGenerate = false;
    }

    public void socketEvent(boolean connected) {
        if (connected) {
            this.shouldGenerate = true;
        } else if (this.shouldGenerate) {
            Log.debug((String)"Generating Flight Report");
            this.flightRecorder.reportIncident(FlightRecorderTriggerType.SOFTWARE_FAILURE);
        }
    }
}

