/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal;

import com.ur.polyscope.controllerinterface.internal.ControllerSocketInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCResponse;
import com.ur.util.logging.Log;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HMCInterfaceImpl
implements HMCInterface {
    private static final int DEFAULT_WAIT_TIME_FOR_RESPONSE = 100;
    private static final String HMC_MESSAGE_FORMAT = "hmc %d %s\n";
    private static final AtomicInteger HMC_MESSAGE_ID = new AtomicInteger(0);
    private ControllerSocketInterface controllerSocket;

    @Inject
    public HMCInterfaceImpl(ControllerSocketInterface controllerSocket) {
        this.controllerSocket = controllerSocket;
    }

    public HMCResponse sendHMCMessageAndWait(String message) {
        return this.sendHMCMessageAndWait(message, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HMCResponse sendHMCMessageAndWait(String message, int waitTime) {
        int messageId = HMCInterfaceImpl.getNextMessageId();
        String messageToSend = String.format(HMC_MESSAGE_FORMAT, messageId, message);
        HMCResponse[] hmcResponseMessage = new HMCResponse[]{null};
        CountDownLatch latch = new CountDownLatch(1);
        if (this.controllerSocket.isConnected() && this.controllerSocket.isControllerAvailable()) {
            this.controllerSocket.registerHMCMessageListener(messageId, message1 -> {
                hmcResponseMessage[0] = message1;
                latch.countDown();
            });
            this.controllerSocket.writeBytes(messageToSend);
            try {
                if (!latch.await(waitTime, TimeUnit.MILLISECONDS)) {
                    Log.error((String)"sendHMCMessageAndWait: timeout");
                    HMCResponse hMCResponse = null;
                    return hMCResponse;
                }
            }
            catch (InterruptedException e) {
                Log.error((String)("sendHMCMessageAndWait: " + e));
                Thread.currentThread().interrupt();
            }
            finally {
                this.controllerSocket.unregisterHMCMessageListener(messageId);
            }
            if (hmcResponseMessage[0] == null) {
                Log.error((String)("Package " + messageId + " did not receive a response in time.\r\tMessage:  " + messageToSend));
            }
        }
        return hmcResponseMessage[0];
    }

    private static int getNextMessageId() {
        return HMC_MESSAGE_ID.getAndIncrement();
    }

    static interface HMCMessageListener {
        public void deliverMessage(HMCResponse var1);
    }
}

