/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal;

import com.ur.polyscope.controllerinterface.MessageConsumer;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.polyscope.controllerinterface.internal.ControllerSocket;
import com.ur.polyscope.controllerinterface.internal.ControllerSocketInterface;
import com.ur.polyscope.controllerinterface.internal.HMCInterfaceImpl;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class LegacyControllerSocketImpl
implements ControllerSocketInterface {
    private Set<MessageConsumer> messageConsumers;
    private Set<RobotStatePackageConsumer> robotStatePackageConsumers;
    private boolean initialized;

    @Override
    public void initialize(Set<MessageConsumer> messageConsumers, Set<RobotStatePackageConsumer> robotStatePackageConsumers) {
        this.messageConsumers = messageConsumers;
        this.robotStatePackageConsumers = robotStatePackageConsumers;
        this.initialized = true;
    }

    @Override
    public void startConnection() {
        if (!this.initialized) {
            throw new IllegalStateException("Controller Socket was not initialized");
        }
        ControllerSocket.initialize(this.messageConsumers, this.robotStatePackageConsumers);
        ControllerSocket.startConnectionThread();
    }

    @Override
    public void stopConnection() {
        ControllerSocket.disconnect();
    }

    @Override
    public boolean isConnected() {
        return ControllerSocket.isConnected();
    }

    @Override
    public boolean isControllerAvailable() {
        return ControllerSocket.isControllerAvailable();
    }

    @Override
    public boolean writeBytes(String s) {
        return ControllerSocket.writeBytes(s);
    }

    @Override
    public void registerHMCMessageListener(int messageId, HMCInterfaceImpl.HMCMessageListener listener) {
        ControllerSocket.registerHMCMessageListener(messageId, listener);
    }

    @Override
    public void unregisterHMCMessageListener(int messageId) {
        ControllerSocket.unregisterHMCMessageListener(messageId);
    }
}

