/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.dashboard;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.lang.StringUtils;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import javax.inject.Inject;

@ReadOnlyDashboardAction
public class ScriptCommandAction
implements DashBoardAction {
    private static final Logger LOG = LogFactory.createLogger(ScriptCommandAction.class);
    private static final String INKOGNITO = "inkognito";
    private ControllerInterface controllerInterface;

    @Inject
    public ScriptCommandAction(ControllerInterface controllerInterface) {
        this.controllerInterface = controllerInterface;
    }

    public boolean canHandleMessage(String input) {
        return StringUtils.startsWithAnyIgnoreCase((String)input, (String[])new String[]{"urscript command"});
    }

    public String execute(String input) {
        String command = input.substring("urscript command ".length());
        LOG.debug("Sending message: " + command, new Object[0]);
        this.controllerInterface.runScript("def inkognito():\n  " + command + "\nend\n");
        LOG.debug("Sent: " + command, new Object[0]);
        return "URScript command: " + command;
    }
}

