/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.flightrecord;

import com.ur.lang.IOUtil;
import com.ur.polyscope.controllerinterface.internal.flightrecord.CircularByteArray;
import com.ur.polyscope.controllerinterface.internal.flightrecord.RealTimeData;
import com.ur.polyscope.controllerinterface.internal.flightrecord.StreamReader;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.util.Waiting;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ConnectionMonitoring
implements Runnable {
    private static final Logger LOG = LogFactory.createLogger(ConnectionMonitoring.class);
    private static final long RECONNECT_DELAY = 3L;
    private static final int MAX_TIMEOUTS = 10;
    static final int MAX_MESSAGE_SIZE = 1500;
    private final AtomicInteger timeoutCounter = new AtomicInteger(0);
    private CircularByteArray window;
    private int windowSize;
    private volatile boolean stopping = false;

    ConnectionMonitoring(int windowSize) {
        this.windowSize = windowSize;
        this.window = new CircularByteArray(windowSize, 1500);
    }

    List<byte[]> getWindow() {
        CircularByteArray oldWindow = this.window;
        this.window = new CircularByteArray(this.windowSize, 1500);
        return oldWindow.asList();
    }

    void stopGracefully() {
        this.stopping = true;
    }

    @Override
    public void run() {
        while (!this.stopping) {
            StreamReader reader = null;
            try {
                reader = new StreamReader();
                this.tryReceiveDataLoop(new RealTimeData(reader));
            }
            catch (IOException ioe) {
                LOG.info("Controller monitoring socket not connected: ", (Throwable)ioe);
            }
            finally {
                IOUtil.close((Closeable)reader);
            }
            if (this.stopping) continue;
            Waiting.pause((long)3L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private void tryReceiveDataLoop(RealTimeData realTimeData) {
        LOG.info("Starting controller monitoring connection", new Object[0]);
        try {
            this.receiveDataLoop(realTimeData);
        }
        catch (IOException ioe) {
            LOG.warn("Controller monitoring socket not connected: ", (Throwable)ioe);
        }
    }

    private void receiveDataLoop(RealTimeData realTimeData) throws IOException {
        while (!this.stopping) {
            try {
                realTimeData.receivePackage(this.window.next());
                this.resetTimeoutCounter();
            }
            catch (SocketTimeoutException ignored) {
                LOG.info("Controller monitoring timed out while waiting for real time robot data", new Object[0]);
                if (!this.timedOutTooFrequently()) continue;
                break;
            }
        }
    }

    private void resetTimeoutCounter() {
        this.timeoutCounter.set(0);
    }

    private boolean timedOutTooFrequently() {
        int timeouts = this.timeoutCounter.incrementAndGet();
        if (timeouts >= 10) {
            LOG.warn("Controller monitoring timed out too many times. Restarting connection", new Object[0]);
            this.resetTimeoutCounter();
            return true;
        }
        return false;
    }
}

