/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.flightrecord;

import java.nio.ByteBuffer;

final class PackageWriter {
    public static final String RESERVED = ",reserved";

    private PackageWriter() {
    }

    static String toCSV(byte[] columns) {
        StringBuilder sb = new StringBuilder(2000);
        boolean first = true;
        ByteBuffer wrappedRealTime = ByteBuffer.wrap(columns);
        int messageLength = wrappedRealTime.getInt();
        int i = 4;
        while (i + 8 <= messageLength && i + 8 <= columns.length) {
            if (!first) {
                sb.append(",");
            }
            sb.append(wrappedRealTime.getDouble());
            first = false;
            i += 8;
        }
        return sb.toString();
    }

    static String headers() {
        return "Timestamp [s],Target position j0 [rad],Target position j1 [rad],Target position j2 [rad],Target position j3 [rad],Target position j4 [rad],Target position j5 [rad],Target velocity j0 [rad/s],Target velocity j1 [rad/s],Target velocity j2 [rad/s],Target velocity j3 [rad/s],Target velocity j4 [rad/s],Target velocity j5 [rad/s],Target acceleration j0 [rad/s^2],Target acceleration j1 [rad/s^2],Target acceleration j2 [rad/s^2],Target acceleration j3 [rad/s^2],Target acceleration j4 [rad/s^2],Target acceleration j5 [rad/s^2],Target current j0 [A],Target current j1 [A],Target current j2 [A],Target current j3 [A],Target current j4 [A],Target current j5 [A],Target moment j0 [Nm],Target moment j1 [Nm],Target moment j2 [Nm],Target moment j3 [Nm],Target moment j4 [Nm],Target moment j5 [Nm],Actual position j0 [rad],Actual position j1 [rad],Actual position j2 [rad],Actual position j3 [rad],Actual position j4 [rad],Actual position j5 [rad],Actual velocity j0 [rad/s],Actual velocity j1 [rad/s],Actual velocity j2 [rad/s],Actual velocity j3 [rad/s],Actual velocity j4 [rad/s],Actual velocity j5 [rad/s],Actual current j0 [A],Actual current j1 [A],Actual current j2 [A],Actual current j3 [A],Actual current j4 [A],Actual current j5 [A],reserved,reserved,reserved,reserved,reserved,reserved,Actual TCP pose x [m],Actual TCP pose y [m],Actual TCP pose z [m],Actual TCP pose rx [rad],Actual TCP pose ry [rad],Actual TCP pose rz [rad],Actual TCP velocity x [m/s],Actual TCP velocity y [m/s],Actual TCP velocity z [m/s],Actual TCP velocity rx [rad/s],Actual TCP velocity ry [rad/s],Actual TCP velocity rz [rad/s],TCP force x [N],TCP force y [N],TCP force z [N],TCP force rx [Nm],TCP force ry [Nm],TCP force rz [Nm],Target TCP pose x [m],Target TCP pose y [m],Target TCP pose z [m],Target TCP pose rx [rad],Target TCP pose ry [rad],Target TCP pose rz [rad],Target TCP velocity x [m/s],Target TCP velocity y [m/s],Target TCP velocity z [m/s],Target TCP velocity rx [rad/s],Target TCP velocity ry [rad/s],Target TCP velocity rz [rad/s],Digital inputs,Temperature j0 [C],Temperature j1 [C],Temperature j2 [C],Temperature j3 [C],Temperature j4 [C],Temperature j5 [C],Realtime thread execution time [ms],reserved,Robot mode,Control mode j0,Control mode j1,Control mode j2,Control mode j3,Control mode j4,Control mode j5,Safety mode,reserved,reserved,reserved,reserved,reserved,reserved,Tool accelerometer x [m/s^2],Tool accelerometer y [m/s^2],Tool accelerometer z [m/s^2],reserved,reserved,reserved,reserved,reserved,reserved,Speed scaling,Actual momentum norm [N],reserved,reserved,Main voltage [V],Arm voltage [V],Arm current [A],Voltage j0 [V],Voltage j1 [V],Voltage j2 [V],Voltage j3 [V],Voltage j4 [V],Voltage j5 [V],Digital outputs,Program state,Elbow position x [m],Elbow position y [m],Elbow position z [m],Elbow velocity x [m/s],Elbow velocity y [m/s],Elbow velocity z [m/s],Safety status,reserved,reserved,Script control line,Payload mass [kg],CoG x [m],CoG y [m],CoG z [m],Ixx [kgm^2],Iyy [kgm^2],Izz [kgm^2],Ixy [kgm^2],Ixz [kgm^2],Iyz [kgm^2]";
    }
}

