/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.flightrecord;

import com.ur.polyscope.controllerinterface.internal.flightrecord.Reader;
import com.ur.util.logging.Log;
import java.io.IOException;
import java.nio.ByteBuffer;

public class RealTimeData {
    private Reader reader;

    RealTimeData(Reader reader) {
        this.reader = reader;
    }

    byte[] receivePackage(byte[] messageBuffer) throws IOException {
        int messageLength = this.reader.readInt();
        if (messageLength > 1500) {
            throw new IOException("Unsupported message's length: " + messageLength);
        }
        ByteBuffer.wrap(messageBuffer, 0, 4).putInt(messageLength);
        int totalBytesRead = 4;
        while (totalBytesRead < messageLength) {
            int bytesRead = this.reader.read(messageBuffer, totalBytesRead, messageLength - totalBytesRead);
            if (bytesRead == -1) {
                throw new IOException("Connection lost");
            }
            if ((totalBytesRead += bytesRead) == messageLength) continue;
            Log.info((String)("Incomplete message. Waiting for more data. Message's length: " + messageLength + ", received bytes: " + totalBytesRead));
        }
        return messageBuffer;
    }
}

