/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.flightrecord;

import com.google.common.net.MediaType;
import com.ur.lang.Defense;
import com.ur.polyscope.controllerinterface.internal.flightrecord.ConnectionMonitoring;
import com.ur.polyscope.controllerinterface.internal.flightrecord.PackageWriter;
import com.ur.polyscope.controllerinterface.util.ControllerInterfaceSettings;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.util.logging.Log;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class RealTimeDataProbe
implements FlightRecorderProbe {
    private static final String CONTROLLER_DATA_FILE_NAME = "realtimedata.csv";
    private final int realtimeDataWindowSize = this.getRealtimeDataWindowSize();
    private ConnectionMonitoring monitor = null;
    private Thread thread;

    RealTimeDataProbe() {
        Defense.isCondition((this.realtimeDataWindowSize > 0 ? 1 : 0) != 0, (String)"Implementation doesn't support zero size");
    }

    int getRealtimeDataWindowSize() {
        return ControllerInterfaceSettings.getFlightRecorderWindowSizeInSeconds() * 500;
    }

    public String getName() {
        return "Real-time Data Probe";
    }

    public void write(PrintStream out) {
        if (this.monitor != null) {
            out.println("Number of samples: " + this.realtimeDataWindowSize);
        }
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        if (this.monitor == null) {
            return Collections.emptyList();
        }
        RealtimeDataAttachment realtimeDataAttachment = new RealtimeDataAttachment(this.monitor.getWindow());
        return Collections.singletonList(realtimeDataAttachment);
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.of(FlightRecorderTriggerType.CONTROLLER_REPORTED_ERROR);
    }

    public void startMonitoring() {
        Defense.isNull((Object)this.monitor, (String)"Monitoring thread should already be stopped");
        this.monitor = new ConnectionMonitoring(this.realtimeDataWindowSize);
        this.thread = new Thread((Runnable)this.monitor, "Controller Monitoring");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stopMonitoring() {
        if (this.monitor != null) {
            this.monitor.stopGracefully();
            try {
                this.thread.join(2000L);
            }
            catch (InterruptedException e) {
                Log.warning((String)"Controller monitoring thread did not join in time");
                Thread.currentThread().interrupt();
            }
            this.monitor = null;
            this.thread = null;
        }
    }

    private static class RealtimeDataAttachment
    implements FlightRecorderAttachment {
        private final List<byte[]> realtimeData;

        RealtimeDataAttachment(List<byte[]> realtimeData) {
            this.realtimeData = realtimeData;
        }

        public void write(OutputStream out) {
            this.writeControllerDataToStream(out);
        }

        private void writeControllerDataToStream(OutputStream os) {
            PrintStream out = new PrintStream(os);
            out.println(PackageWriter.headers());
            for (byte[] each : this.realtimeData) {
                String csvRow = PackageWriter.toCSV(each);
                if (csvRow.length() <= 0) continue;
                out.println(csvRow);
            }
        }

        public String getName() {
            return RealTimeDataProbe.CONTROLLER_DATA_FILE_NAME;
        }

        public String getMimeType() {
            return MediaType.CSV_UTF_8.withParameter("header", "present").toString();
        }
    }
}

