/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.flightrecord;

import com.ur.polyscope.controllerinterface.internal.flightrecord.Reader;
import com.ur.polyscope.controllerinterface.util.ControllerInterfaceSettings;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class StreamReader
implements Reader {
    private static final int SOCKET_PORT = 30003;
    private static final int SOCKET_TIMEOUT_MS = 1000;
    private final Socket socket;
    private final DataInputStream dataInputStream;

    public StreamReader() throws IOException {
        this(new Socket(ControllerInterfaceSettings.getControllerSocketIp(), 30003));
    }

    public StreamReader(Socket socket) throws IOException {
        this.socket = socket;
        socket.setSoTimeout(1000);
        InputStream in = socket.getInputStream();
        this.dataInputStream = new DataInputStream(in);
    }

    @Override
    public int readInt() throws IOException {
        return this.dataInputStream.readInt();
    }

    @Override
    public int read(byte[] messageBuffer, int totalBytesRead, int i) throws IOException {
        return this.dataInputStream.read(messageBuffer, totalBytesRead, i);
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }
}

