/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.impl;

import com.google.inject.TypeLiteral;
import com.ur.dashboardserver.DashBoardAction;
import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.ServicesBinder;
import com.ur.lang.react.Recipe;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.CartesianInfo;
import com.ur.monitor.model.Joint;
import com.ur.monitor.model.Masterboard;
import com.ur.monitor.model.RobotMode;
import com.ur.monitor.model.Tool;
import com.ur.polyscope.controllerinterface.AdditionalInfo;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.controllerinterface.ControllerServiceListener;
import com.ur.polyscope.controllerinterface.ControllerServiceManager;
import com.ur.polyscope.controllerinterface.MessageConsumer;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.polyscope.controllerinterface.internal.ControllerInterfaceImpl;
import com.ur.polyscope.controllerinterface.internal.ControllerServiceManagerImpl;
import com.ur.polyscope.controllerinterface.internal.ControllerSocketInterface;
import com.ur.polyscope.controllerinterface.internal.FlightRecordTriggerOnControllerDisconnect;
import com.ur.polyscope.controllerinterface.internal.HMCInterfaceImpl;
import com.ur.polyscope.controllerinterface.internal.LegacyControllerSocketImpl;
import com.ur.polyscope.controllerinterface.internal.RobotModeChangeService;
import com.ur.polyscope.controllerinterface.internal.dashboard.ScriptCommandAction;
import com.ur.polyscope.controllerinterface.internal.flightrecord.RealTimeDataProbe;
import com.ur.polyscope.controllerinterface.internal.stream.AdditionalInfoModelSource;
import com.ur.polyscope.controllerinterface.internal.stream.AdditionalInfoPackageConsumer;
import com.ur.polyscope.controllerinterface.internal.stream.ArmModelSource;
import com.ur.polyscope.controllerinterface.internal.stream.CartesianInfoModelSource;
import com.ur.polyscope.controllerinterface.internal.stream.CartesianInfoPackageConsumer;
import com.ur.polyscope.controllerinterface.internal.stream.CumulativeRuntimeDataPackageConsumer;
import com.ur.polyscope.controllerinterface.internal.stream.ForceModeDataPackageConsumer;
import com.ur.polyscope.controllerinterface.internal.stream.JointModelSource;
import com.ur.polyscope.controllerinterface.internal.stream.JointPackageConsumer;
import com.ur.polyscope.controllerinterface.internal.stream.MasterboardDataPackageConsumer;
import com.ur.polyscope.controllerinterface.internal.stream.MasterboardModelSource;
import com.ur.polyscope.controllerinterface.internal.stream.ModelStateChangeDistributor;
import com.ur.polyscope.controllerinterface.internal.stream.RobotModeDataPackageConsumer;
import com.ur.polyscope.controllerinterface.internal.stream.RobotModeSource;
import com.ur.polyscope.controllerinterface.internal.stream.ToolDataPackageConsumer;
import com.ur.polyscope.controllerinterface.internal.stream.ToolModelSource;
import com.ur.polyscope.controllerinterface.synchroneous.HMCInterface;
import com.ur.polyscope.controllerinterface.util.ControllerInterfaceSettings;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;

public class ServiceBinderImpl
implements ServicesBinder {
    private Builder builder;

    public void bind(Binder binder) {
        binder.bindClass(ControllerSocketInterface.class, LegacyControllerSocketImpl.class);
        binder.bindClass(ControllerInterface.class, ControllerInterfaceImpl.class);
        binder.bindClass(ControllerServiceManager.class, ControllerServiceManagerImpl.class);
        binder.bindClass(ControllerServiceListener.class, FlightRecordTriggerOnControllerDisconnect.class);
        binder.bindClass(HMCInterface.class, HMCInterfaceImpl.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<Arm>>(){}, ArmModelSource.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<RobotMode>>(){}, RobotModeSource.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<Joint>>(){}, JointModelSource.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<Tool>>(){}, ToolModelSource.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<CartesianInfo>>(){}, CartesianInfoModelSource.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<Masterboard>>(){}, MasterboardModelSource.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<AdditionalInfo>>(){}, AdditionalInfoModelSource.class);
        binder.bindToExtensionPoint(RobotStatePackageConsumer.class, JointPackageConsumer.class);
        binder.bindToExtensionPoint(RobotStatePackageConsumer.class, RobotModeDataPackageConsumer.class);
        binder.bindToExtensionPoint(RobotStatePackageConsumer.class, CartesianInfoPackageConsumer.class);
        binder.bindToExtensionPoint(RobotStatePackageConsumer.class, MasterboardDataPackageConsumer.class);
        binder.bindToExtensionPoint(RobotStatePackageConsumer.class, ToolDataPackageConsumer.class);
        binder.bindToExtensionPoint(RobotStatePackageConsumer.class, ForceModeDataPackageConsumer.class);
        binder.bindToExtensionPoint(RobotStatePackageConsumer.class, AdditionalInfoPackageConsumer.class);
        binder.bindToExtensionPoint(RobotStatePackageConsumer.class, CumulativeRuntimeDataPackageConsumer.class);
        binder.bindToExtensionPoint(FlightRecorderProbe.class, RealTimeDataProbe.class);
        if (ControllerInterfaceSettings.isRunningInDevelopmentMode()) {
            binder.bindToExtensionPoint(DashBoardAction.class, ScriptCommandAction.class);
        }
    }

    public void load(Builder builder) {
        builder.get(ArmModelSource.class);
        builder.get(RobotModeSource.class);
        builder.get(ModelStateChangeDistributor.class);
        builder.get(AdditionalInfoModelSource.class);
        builder.get(FlightRecordTriggerOnControllerDisconnect.class);
        EventNotificationService.register(null, RobotStateListener.class, (Object)((RobotStateListener)builder.get(RobotModeChangeService.class)));
        this.builder = builder;
    }

    void startControllerConnection() {
        if (this.builder == null) {
            throw new IllegalStateException("Unable to find builder to initialize Controller connection");
        }
        Log.info((String)"Starting Controller Connection");
        ControllerSocketInterface controllerSocket = (ControllerSocketInterface)this.builder.get(ControllerSocketInterface.class);
        controllerSocket.initialize(this.builder.getExtensions(MessageConsumer.class), this.builder.getExtensions(RobotStatePackageConsumer.class));
        controllerSocket.startConnection();
        RealTimeDataProbe realTimeDataProbe = (RealTimeDataProbe)this.builder.get(RealTimeDataProbe.class);
        realTimeDataProbe.startMonitoring();
    }

    void stopControllerConnection() {
        Log.info((String)"Stopping Controller Connection");
        ((FlightRecordTriggerOnControllerDisconnect)this.builder.get(FlightRecordTriggerOnControllerDisconnect.class)).beforeDisconnect();
        ControllerSocketInterface controllerSocket = (ControllerSocketInterface)this.builder.get(ControllerSocketInterface.class);
        controllerSocket.stopConnection();
        RealTimeDataProbe realTimeDataProbe = (RealTimeDataProbe)this.builder.get(RealTimeDataProbe.class);
        realTimeDataProbe.stopMonitoring();
    }
}

