/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.stream;

import com.ur.polyscope.controllerinterface.AdditionalInfo;
import com.ur.polyscope.controllerinterface.internal.stream.AbstractRobotStatePackageConsumer;
import com.ur.polyscope.controllerinterface.internal.stream.AdditionalInfoModelSource;
import com.ur.view.constants.comm.RobotStatePackageType;
import com.ur.view.constants.dev.TPButtonState;
import com.ur.view.constants.dev.TPType;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AdditionalInfoPackageConsumer
extends AbstractRobotStatePackageConsumer {
    private static final int SIZE_IN_BYTES = 4;
    private final AdditionalInfoModelSource modelSource;

    @Inject
    public AdditionalInfoPackageConsumer(AdditionalInfoModelSource modelSource) {
        super(RobotStatePackageType.ADDITIONAL_INFO);
        this.modelSource = modelSource;
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        TPButtonState tpButtonState = TPButtonState.byId((int)stream.readByte());
        boolean teachButtonEnabled = stream.readBoolean();
        boolean freedriveIOPressed = stream.readBoolean();
        TPType tpType = TPType.byId((int)stream.readByte());
        this.robotState.teachButtonPressed = tpButtonState != TPButtonState.RELEASED;
        this.robotState.teachButtonEnabled = teachButtonEnabled;
        this.robotState.freedriveIOPressed = freedriveIOPressed;
        this.modelSource.emit(new AdditionalInfo(tpButtonState, teachButtonEnabled, freedriveIOPressed, tpType));
        return 4;
    }
}

