/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.stream;

import com.ur.monitor.ModelSource;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.CartesianInfo;
import com.ur.monitor.model.Joint;
import com.ur.monitor.model.JointType;
import com.ur.monitor.model.Tool;
import com.ur.polyscope.controllerinterface.internal.stream.CartesianInfoModelSource;
import com.ur.polyscope.controllerinterface.internal.stream.JointModelSource;
import com.ur.polyscope.controllerinterface.internal.stream.ToolModelSource;
import com.ur.util.event.EventManager;
import com.ur.view.constants.dev.JointMode;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Source(value=Arm.class)
public class ArmModelSource
extends ModelSource<Arm>
implements RobotStateListener {
    private CartesianInfoModelSource cartesianInfoModelSource;
    private ToolModelSource toolModeSource;
    private JointModelSource jointModeSource;

    @Inject
    public ArmModelSource(EventManager eventManager, CartesianInfoModelSource cartesianInfoModelSource, ToolModelSource toolModeSource, JointModelSource jointModeSource) {
        this.cartesianInfoModelSource = cartesianInfoModelSource;
        this.toolModeSource = toolModeSource;
        this.jointModeSource = jointModeSource;
        eventManager.addStrongListener(RobotStateListener.class, (Object)this);
        this.updateRobotState(RobotState.getLatestRobotState());
    }

    public void updateRobotState(RobotState robotState) {
        ArrayList<Joint> joints = new ArrayList<Joint>();
        CartesianInfo cartesianInfo = new CartesianInfo(robotState.tcpOffset, robotState.tool);
        Tool tool = new Tool(cartesianInfo, robotState.toolVoltage48V, robotState.toolOutputVoltage, robotState.toolCurrent, robotState.toolTemperature, robotState.toolMode);
        for (JointType each : JointType.values()) {
            joints.add(new Joint(each, robotState.jointPosition.getJoint(each), robotState.targetJointPosition.getJoint(each), robotState.jointSpeed.getJoint(each), robotState.jointCurrent[each.getJointNumber()], robotState.jointVoltage[each.getJointNumber()], robotState.jointMotorTemperature[each.getJointNumber()], robotState.jointMicroTemperature[each.getJointNumber()], JointMode.byId((int)robotState.jointMode[each.getJointNumber()])));
        }
        Arm arm = new Arm(robotState.real, robotState.robotPowerOn, tool, joints);
        this.cartesianInfoModelSource.emit(cartesianInfo);
        this.toolModeSource.emit(tool);
        this.jointModeSource.emit(joints);
        this.broadcaster.next((Object)arm);
    }
}

