/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.stream;

import com.ur.monitor.model.JointSpeedVector;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.controllerinterface.internal.stream.AbstractRobotStatePackageConsumer;
import com.ur.view.constants.comm.RobotStatePackageType;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Singleton;

@Singleton
public class JointPackageConsumer
extends AbstractRobotStatePackageConsumer {
    private static final int SIZE_IN_BYTES = 41;

    public JointPackageConsumer() {
        super(RobotStatePackageType.JOINT_DATA);
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        if (this.robotState.robotPowerOn) {
            this.robotState.hasReceivedPositionData = true;
        }
        int messageOffset = 0;
        double[] jointSpeedValues = new double[6];
        for (JointType jointTypeName : JointType.values()) {
            int jointNumber = jointTypeName.getJointNumber();
            this.robotState.jointPosition.setJoint(jointNumber, stream.readDouble());
            this.robotState.targetJointPosition.setJoint(jointNumber, stream.readDouble());
            jointSpeedValues[jointNumber] = stream.readDouble();
            this.robotState.jointCurrent[jointNumber] = stream.readFloat();
            this.robotState.jointVoltage[jointNumber] = stream.readFloat();
            this.robotState.jointMotorTemperature[jointNumber] = stream.readFloat();
            this.robotState.jointMicroTemperature[jointNumber] = stream.readFloat();
            int mode = stream.readByte();
            if (mode < 0) {
                mode += 256;
            }
            this.robotState.jointMode[jointNumber] = mode;
            messageOffset += 41;
        }
        this.robotState.jointSpeed = new JointSpeedVector(jointSpeedValues);
        return messageOffset;
    }
}

