/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.stream;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.internal.stream.AbstractRobotStatePackageConsumer;
import com.ur.view.constants.comm.RobotStatePackageType;
import com.ur.view.constants.dev.SafetyMode;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Singleton;

@Singleton
public class MasterboardDataPackageConsumer
extends AbstractRobotStatePackageConsumer {
    private static final int SIZE_IN_BYTES = 62;
    private static final int EUROMAP67_SIZE_IN_BYTES = 16;
    private static final int POST_EUROMAP_SIZE_IN_BYTES = 1;

    public MasterboardDataPackageConsumer() {
        super(RobotStatePackageType.MASTERBOARD_DATA);
    }

    @Override
    public RobotStatePackageType getPackageType() {
        return RobotStatePackageType.MASTERBOARD_DATA;
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        int messageOffset = 0;
        this.robotState.setDigitalIn(stream.readInt());
        this.robotState.setDigitalOut(stream.readInt());
        this.robotState.analogInputRange[0] = stream.readByte();
        this.robotState.analogInputRange[1] = stream.readByte();
        this.robotState.analogIn[0] = stream.readDouble();
        this.robotState.analogIn[1] = stream.readDouble();
        this.robotState.analogOutputDomain[0] = stream.readByte();
        this.robotState.analogOutputDomain[1] = stream.readByte();
        this.robotState.analogOut[0] = stream.readDouble();
        this.robotState.analogOut[1] = stream.readDouble();
        this.robotState.masterTemperature = stream.readFloat();
        this.robotState.robotVoltage48V = stream.readFloat();
        this.robotState.robotCurrent = stream.readFloat();
        this.robotState.masterIOCurrent = stream.readFloat();
        this.robotState.aggregatedSafetyMode = SafetyMode.byId((int)stream.readByte());
        this.robotState.reducedModeActive = stream.readByte() > 0;
        messageOffset += 62;
        byte isEuromapHardwarePresent = stream.readByte();
        ++messageOffset;
        if (isEuromapHardwarePresent == 1) {
            this.robotState.setEuromapInput((long)stream.readInt());
            this.robotState.setEuromapOutput((long)stream.readInt());
            this.robotState.euromap24V_voltage = stream.readFloat();
            this.robotState.euromap24V_current = stream.readFloat();
            messageOffset += 16;
        }
        stream.skipBytes(6);
        messageOffset += 6;
        this.robotState.masterSafetyState = SafetyMode.byId((int)stream.readByte());
        return ++messageOffset;
    }

    @Override
    public void initialize(RobotState robotState) {
        this.robotState = robotState;
    }
}

