/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.stream;

import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.model.Euromap67;
import com.ur.monitor.model.Masterboard;
import com.ur.polyscope.controllerinterface.internal.stream.MasterboardModelSource;
import com.ur.util.event.EventManager;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ModelStateChangeDistributor
implements RobotStateListener {
    MasterboardModelSource masterboardModelSource;

    @Inject
    ModelStateChangeDistributor(MasterboardModelSource masterboardModelSource, EventManager eventManager) {
        this.masterboardModelSource = masterboardModelSource;
        eventManager.addStrongListener(RobotStateListener.class, (Object)this);
    }

    private Masterboard buildFromOriginalSource(RobotState robotState) {
        Euromap67 euromap67 = new Euromap67(robotState.euromapInput, robotState.euromapOutput, robotState.euromap24V_voltage, robotState.euromap24V_current);
        return new Masterboard(robotState.timestamp, robotState.digitalIn, robotState.digitalOut, robotState.configurableIn, robotState.configurableOut, robotState.analogInputRange, robotState.analogOutputDomain, robotState.analogIn, robotState.analogOut, robotState.masterTemperature, robotState.robotVoltage48V, robotState.robotCurrent, robotState.masterIOCurrent, robotState.masterSafetyState, robotState.reducedModeActive, euromap67);
    }

    public void updateRobotState(RobotState robotState) {
        this.masterboardModelSource.emit(this.buildFromOriginalSource(robotState));
    }
}

