/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.stream;

import com.ur.polyscope.controllerinterface.internal.stream.AbstractRobotStatePackageConsumer;
import com.ur.view.constants.comm.RobotStatePackageType;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.runtime.ControlMode;
import com.ur.view.constants.runtime.SpeedMode;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Singleton;

@Singleton
public class RobotModeDataPackageConsumer
extends AbstractRobotStatePackageConsumer {
    private static final int SIZE_IN_BYTES = 42;

    public RobotModeDataPackageConsumer() {
        super(RobotStatePackageType.ROBOT_MODE_DATA);
    }

    @Override
    public RobotStatePackageType getPackageType() {
        return RobotStatePackageType.ROBOT_MODE_DATA;
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        this.robotState.timestamp = stream.readLong();
        stream.readBoolean();
        this.robotState.real = stream.readBoolean();
        this.robotState.robotPowerOn = stream.readBoolean();
        this.robotState.emergencyStopped = stream.readBoolean();
        this.robotState.securityStopped = stream.readBoolean();
        this.robotState.programRunning = stream.readBoolean();
        this.robotState.programPaused = stream.readBoolean();
        byte mode = stream.readByte();
        if (mode < 0) {
            mode = (byte)(mode + 256);
        }
        this.robotState.robotMode = RobotMode.byId((int)mode);
        this.robotState.controlMode = ControlMode.byId((int)stream.readByte());
        this.robotState.speedFraction = stream.readDouble();
        this.robotState.speedScaling = stream.readDouble();
        this.robotState.speedFractionLimit = stream.readDouble();
        this.robotState.speedMode = SpeedMode.byId((int)stream.readByte());
        return 42;
    }
}

