/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.controllerinterface.internal.stream;

import com.ur.monitor.ModelSource;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.Source;
import com.ur.monitor.StreamedModel;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.util.event.EventManager;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.runtime.ControlMode;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Source(value=com.ur.monitor.model.RobotMode.class)
public class RobotModeSource
extends ModelSource<com.ur.monitor.model.RobotMode>
implements RobotStateListener {
    private static Logger logger = LogFactory.createLogger(RobotModeSource.class);

    @Inject
    RobotModeSource(EventManager eventManager) {
        super((StreamedModel)new com.ur.monitor.model.RobotMode(0L, false, false, false, false, RobotMode.DISCONNECTED, ControlMode.POSITION, SafetyMode.UNDEFINED_SAFETY_MODE, 0.0, 0.0, 0.0));
        eventManager.addStrongListener(RobotStateListener.class, (Object)this);
    }

    public void updateRobotState(RobotState robotState) {
        com.ur.monitor.model.RobotMode robotMode = new com.ur.monitor.model.RobotMode(robotState.timestamp, robotState.emergencyStopped, robotState.securityStopped, robotState.programRunning, robotState.programPaused, robotState.robotMode, robotState.controlMode, robotState.masterSafetyState, robotState.speedFraction, robotState.speedScaling, robotState.speedFractionLimit);
        com.ur.monitor.model.RobotMode previousRobotMode = (com.ur.monitor.model.RobotMode)this.broadcaster.lastProvider().get();
        this.broadcaster.next((Object)robotMode);
        this.traceRouteIfDifferent(robotMode, previousRobotMode);
    }

    private void traceRouteIfDifferent(com.ur.monitor.model.RobotMode newRobotMode, com.ur.monitor.model.RobotMode previousRobotMode) {
        if (!newRobotMode.equalsWithoutScaling(previousRobotMode)) {
            logger.traceRoute((Object)newRobotMode);
        }
    }

    static void setLogger(Logger logger) {
        RobotModeSource.logger = logger;
    }
}

