/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.scriptconverter;

import com.ur.util.logging.Log;

public class ScriptConverter {
    private static StringBuilder toScriptCode(char c, boolean bijective, StringBuilder s) {
        if (bijective && c == 'u') {
            s.append("uu");
        } else if (c < '\u0080') {
            s.append(c);
        } else {
            s.append('u').append((int)c);
        }
        return s;
    }

    public static String toScriptCode(String s, boolean bijective) {
        if (s == null) {
            return null;
        }
        StringBuilder outString = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            ScriptConverter.toScriptCode(c, bijective, outString);
            ++i;
        }
        return outString.toString();
    }

    public static String fromScriptCode(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder outString = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == 'u') {
                boolean malformed = i + 1 >= s.length();
                char firstEscapeCharacter = '\u0000';
                if (!malformed) {
                    firstEscapeCharacter = s.charAt(i + 1);
                    boolean bl = malformed = firstEscapeCharacter != 'u' && !Character.isDigit(firstEscapeCharacter);
                }
                if (malformed) {
                    Log.error((String)("Malformed escape sequence in string: " + s));
                    outString.append(c);
                } else if (firstEscapeCharacter == 'u') {
                    outString.append('u');
                    ++i;
                } else {
                    int escapedCharacterCode = 0;
                    while (i + 1 < s.length() && Character.isDigit(s.charAt(i + 1))) {
                        escapedCharacterCode = escapedCharacterCode * 10 + (s.charAt(i + 1) - 48);
                        ++i;
                    }
                    outString.append((char)escapedCharacterCode);
                }
            } else {
                outString.append(c);
            }
            ++i;
        }
        return outString.toString();
    }
}

