/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.scriptwriter;

import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class ScriptGeneratorLookup {
    List<GeneratorPositionPair> generators = new CopyOnWriteArrayList<GeneratorPositionPair>();

    public void clear() {
        this.generators.clear();
    }

    private GeneratorPositionPair findScriptGeneratorEntry(ScriptWriter.ScriptPosition originalScriptPosition) {
        ScriptWriter.ScriptPosition scriptPosition = this.createLinePositionIfNoColumnValue(originalScriptPosition);
        GeneratorPositionPair best = null;
        for (GeneratorPositionPair entry : this.generators) {
            Range range = entry.getValue();
            if (!range.contains(scriptPosition) || best != null && !range.within(best.getValue()) && !range.equal(best.getValue())) continue;
            best = entry;
        }
        return best;
    }

    private ScriptWriter.ScriptPosition createLinePositionIfNoColumnValue(ScriptWriter.ScriptPosition scriptPosition) {
        return scriptPosition.getColumn() == 0 ? new ScriptWriter.ScriptPosition(scriptPosition.getLine()) : scriptPosition;
    }

    public ScriptGenerator findScriptGenerator(ScriptWriter.ScriptPosition scriptPosition) {
        GeneratorPositionPair entry = this.findScriptGeneratorEntry(scriptPosition);
        ScriptGenerator best = null;
        if (entry != null) {
            best = entry.getKey();
        }
        return best;
    }

    public Range findScriptRange(ScriptWriter.ScriptPosition scriptPosition) {
        GeneratorPositionPair entry = this.findScriptGeneratorEntry(scriptPosition);
        Range best = null;
        if (entry != null) {
            best = entry.getValue();
        }
        return best;
    }

    public ScriptGenerator findScriptGenerator(String className) {
        ScriptGenerator match = null;
        for (GeneratorPositionPair entry : this.generators) {
            ScriptGenerator generator = entry.getKey();
            if (!generator.getClass().getSimpleName().equals(className)) continue;
            match = generator;
            break;
        }
        return match;
    }

    public ScriptGenerator findScriptGenerator(int id) {
        ScriptGenerator match = null;
        for (GeneratorPositionPair entry : this.generators) {
            ControllerInterfaceProgramNode programNode;
            ScriptGenerator generator = entry.getKey();
            if (!(generator instanceof ControllerInterfaceProgramNode) || (programNode = (ControllerInterfaceProgramNode)((Object)generator)).getId() != id) continue;
            match = generator;
            break;
        }
        return match;
    }

    public Range findScriptGeneratorRange(ScriptGenerator scriptGenerator) {
        Range range = null;
        for (GeneratorPositionPair entry : this.generators) {
            if (entry.getKey() != scriptGenerator) continue;
            range = entry.getValue();
            break;
        }
        return range;
    }

    public void markBeginScript(ScriptGenerator scriptGenerator, ScriptWriter scriptWriter) {
        Range range = new Range(scriptWriter.getCurrentPosition());
        this.generators.add(new GeneratorPositionPair(scriptGenerator, range));
    }

    public void markEndScript(ScriptGenerator scriptGenerator, ScriptWriter scriptWriter) {
        ListIterator<GeneratorPositionPair> listIterator = this.generators.listIterator(this.generators.size());
        while (listIterator.hasPrevious()) {
            GeneratorPositionPair generatorPositionPair = listIterator.previous();
            if (generatorPositionPair.getKey() != scriptGenerator) continue;
            generatorPositionPair.getValue().updateLast(scriptWriter.getCurrentPosition());
            break;
        }
    }

    protected class GeneratorPositionPair {
        protected final ScriptGenerator scriptGenerator;
        protected Range range;

        protected GeneratorPositionPair(ScriptGenerator scriptGenerator, Range range) {
            this.scriptGenerator = scriptGenerator;
            this.range = range;
        }

        protected ScriptGenerator getKey() {
            return this.scriptGenerator;
        }

        protected Range getValue() {
            return this.range;
        }
    }

    public static class Range {
        private final ScriptWriter.ScriptPosition start;
        private ScriptWriter.ScriptPosition next;

        Range(ScriptWriter.ScriptPosition first) {
            this.start = first;
            this.next = new ScriptWriter.ScriptPosition(0, 0);
        }

        public Range(ScriptWriter.ScriptPosition first, ScriptWriter.ScriptPosition next) {
            this.start = first;
            this.next = next;
        }

        public void updateLast(ScriptWriter.ScriptPosition last) {
            this.next = last;
        }

        public boolean equal(Range range) {
            return this.start.equal(range.start) && this.next.equal(range.next);
        }

        public boolean within(Range range) {
            return !this.equal(range) && this.start.largerEqual(range.start) && this.next.lessEqual(range.next);
        }

        public boolean contains(ScriptWriter.ScriptPosition scriptPosition) {
            return this.start.lessEqual(scriptPosition) && this.next.larger(scriptPosition);
        }

        public ScriptWriter.ScriptPosition getStart() {
            return this.start;
        }

        public ScriptWriter.ScriptPosition getNext() {
            return this.next;
        }

        public String toString() {
            return "[" + this.start.toString() + ", " + this.next.toString() + "]";
        }
    }
}

