/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.scriptwriter;

import com.ur.lang.Defense;
import com.ur.lang.StringUtils;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.util.CollectionUtils;
import java.io.Serializable;
import java.util.Map;
import javax.vecmath.Vector3d;

public class ScriptWriter {
    private static final double END_FORCE_MODE_DEACCELERATION = 5.0;
    private final StringBuilder scriptBuilder = new StringBuilder();
    private int minimumIndentationLevel = 0;
    private int indentationLevel = 0;
    private ScriptPosition currentPosition = new ScriptPosition(1, 1);

    public ScriptPosition getCurrentPosition() {
        return new ScriptPosition(this.currentPosition);
    }

    public void appendLine(String text) {
        if (text != null) {
            Defense.isCondition((StringUtils.split((String)"\n", (String)text.trim()).length == 1 ? 1 : 0) != 0, (String)("Should be only a single line, but was:\n\n\t" + text));
            this.writeText(StringUtils.trimTrailing((String)text));
        }
    }

    public void appendRaw(String script) {
        this.scriptBuilder.append(script);
    }

    public void writeScript(String script) {
        this.writeText(script);
    }

    public void returnMethod() {
        this.writeText("return");
    }

    public void globalVariable(String name, String value) {
        this.writeText("global " + name + "=" + value);
    }

    public void localVariable(String name, String value) {
        this.writeText("local " + name + "=" + value);
    }

    public void incrementVariable(String variableName) {
        this.assign(variableName, String.valueOf(variableName) + " + 1");
    }

    public void assign(String varibleName, String expression) {
        this.writeText(String.valueOf(varibleName) + " = " + expression);
    }

    public void end() {
        this.decreaseIndentation();
        this.writeText("end");
    }

    public void ifCondition(String expression) {
        this.writeText("if (" + expression + "):");
        this.increaseIndentation();
    }

    public void ifNotCondition(String expression) {
        this.writeText("if not(" + expression + "):");
        this.increaseIndentation();
    }

    public void elseIfCondition(String expression) {
        this.decreaseIndentation();
        this.writeText("elif (" + expression + "):");
        this.increaseIndentation();
    }

    public void elseCondition() {
        this.decreaseIndentation();
        this.writeText("else:");
        this.increaseIndentation();
    }

    public void whileTrue() {
        this.whileCondition("True");
    }

    public void whileNot(String expression) {
        this.whileCondition("not(" + expression + ")");
    }

    public void whileCondition(String expression) {
        this.writeText("while (" + expression + "):");
        this.increaseIndentation();
    }

    public void defineThread(String threadName) {
        this.writeText("thread " + threadName + "():");
        this.increaseIndentation();
    }

    public void runThreadNoParentheses(String variableName, String threadName) {
        this.writeText(String.valueOf(variableName) + " = run " + threadName);
    }

    public void runThread(String variableName, String threadName) {
        this.writeText(String.valueOf(variableName) + " = run " + threadName + "()");
    }

    public void killThread(String threadName) {
        this.writeText("kill " + threadName);
    }

    public void defineFunction(String name) {
        this.writeText("def " + name + "():");
        this.increaseIndentation();
    }

    public void defineFunctionWithParameters(String name, String ... params) {
        this.writeText("def " + name + "(" + StringUtils.joinStringsWith((String)", ", (Object[])params) + "):");
        this.increaseIndentation();
    }

    public void defineSecondary(String name) {
        this.writeText("sec " + name + "():");
        this.increaseIndentation();
    }

    public void writeProgramLabel(ControllerInterfaceProgramNode node) {
        if (node.getGenerateProgramLabel()) {
            String correctedString = node.toString().replace('\"', '\'');
            Object[] labelProperties = node.getLabelProperties();
            String propertiesTextToAppend = labelProperties != null && labelProperties.length > 0 ? " \"" + StringUtils.joinStringsWith((String)", ", (Object[])labelProperties) + "\"" : "";
            this.writeText("$ " + node.getId() + " \"" + correctedString + "\"" + propertiesTextToAppend);
        }
    }

    public void comment(String text) {
        this.writeText("# " + text);
    }

    public void popup(Map<MessageDialogType, String> messagePopupToGenerator, MessageDialogType type, String message, boolean isBlocking) {
        this.writeText(String.format(messagePopupToGenerator.get(type), message, isBlocking ? "True" : "False"));
    }

    public void popup(String message, String title, PopupLevel level, boolean isBlocking) {
        this.writeText(level.generateText(message, title, isBlocking));
    }

    public void halt() {
        this.writeText("halt");
    }

    public void forceMode(String name, int[] selectionVector, double[] forceModeWrench, int forceType, double[] limits) {
        this.writeText("force_mode(" + StringUtils.joinStringsWith((String)", ", (Object[])new Serializable[]{name, "[" + StringUtils.joinStringsWith((String)", ", (int[])selectionVector) + "]", "[" + StringUtils.joinStringsWith((String)", ", (double[])forceModeWrench) + "]", Integer.valueOf(forceType), "[" + StringUtils.joinStringsWith((String)", ", (double[])limits) + "]"}) + ")");
    }

    public void endForceMode() {
        this.writeText("end_force_mode()");
        this.stopl(5.0);
    }

    public void insertBreak() {
        this.writeText("break");
    }

    public void sync() {
        this.writeText("sync()");
    }

    public void sleep(double seconds) {
        this.writeText("sleep(" + seconds + ")");
    }

    public void stopl(double cartesianAcceleration) {
        this.writeText("stopl(" + cartesianAcceleration + ")");
    }

    public void stopj(double cartesianAcceleration) {
        this.writeText("stopj(" + cartesianAcceleration + ")");
    }

    public void speedl(String xd, double cartesianAcceleration, String time, String aRot) {
        this.writeText("speedl(" + xd + ", " + cartesianAcceleration + ", " + time + ", " + aRot + ")");
    }

    public void speedl(String xd, double cartesianAcceleration, String time) {
        this.writeText("speedl(" + xd + ", " + cartesianAcceleration + ", t=" + time + ")");
    }

    public void speedj(String qd, double jointAcceleration, String time) {
        this.writeText("speedj(" + qd + ", " + jointAcceleration + ", t=" + time + ")");
    }

    public void movel(String poseVarName, double acc, double speed) {
        this.movel(poseVarName, "" + acc, "" + speed);
    }

    public void movel(String poseVarName, String acc, String spd) {
        this.writeText(String.format("movel(%s, a=%s, v=%s)", poseVarName, acc, spd));
    }

    public void movel(String poseVarName, String acc, String spd, String blendRadius) {
        this.writeText(String.format("movel(%s, a=%s, v=%s, r=%s)", poseVarName, acc, spd, blendRadius));
    }

    public void movep(String poseVarName, double acc, double speed) {
        this.movep(poseVarName, "" + acc, "" + speed);
    }

    public void movep(String poseVarName, String acc, String spd) {
        this.writeText(String.format("movep(%s, a=%s, v=%s)", poseVarName, acc, spd));
    }

    public void movep(String poseVarName, String acc, String spd, String blendRadius) {
        this.writeText(String.format("movep(%s, a=%s, v=%s, r=%s)", poseVarName, acc, spd, blendRadius));
    }

    public void movej(JointPositionVector pos) {
        this.writeText(String.format("movej(%s)", pos.toString()));
    }

    public void movej(JointPositionVector pos, double acceleration, double speed) {
        this.writeText(String.format("movej(%s, a=%s, v=%s)", pos.toString(), acceleration, speed));
    }

    public void movej(JointPositionVector pos, double time) {
        this.writeText(String.format("movej(%s, a=1.4, v=1.05, t=%s)", pos.toString(), time));
    }

    public void set_pos(JointPositionVector startPos) {
        this.writeText("set_pos(" + startPos.toString() + ")");
    }

    public void set_gravity(Vector3d gravity) {
        this.writeText("set_gravity([" + gravity.x + ", " + gravity.y + ", " + gravity.z + "])");
    }

    @Deprecated
    public void set_payload(double payloadValue) {
        this.set_payload(payloadValue, null);
    }

    public void set_payload(double toolPayload, Vector3d centerOfGravity) {
        StringBuilder sb = new StringBuilder();
        sb.append("set_payload(");
        sb.append(toolPayload);
        if (centerOfGravity != null) {
            sb.append(", [");
            sb.append(StringUtils.joinStringsWith((String)", ", (Object[])new Double[]{centerOfGravity.x, centerOfGravity.y, centerOfGravity.z}));
            sb.append("]");
        }
        sb.append(")");
        this.writeText(sb.toString());
    }

    public void set_payload_mass(double mass) {
        this.writeText("set_payload_mass(" + mass + ")");
    }

    public void set_tcp(Pose6d offset) {
        this.writeText("set_tcp(" + offset.toString() + ")");
    }

    private void writeText(String text) {
        this.scriptBuilder.append(this.tabLevel());
        this.scriptBuilder.append(text);
        this.scriptBuilder.append("\n");
        ScriptPosition scriptPosition = this.currentPosition;
        scriptPosition.line = scriptPosition.line + 1;
        this.currentPosition.column = 1;
    }

    private String tabLevel() {
        return StringUtils.repeat((String)"  ", (int)this.indentationLevel);
    }

    private void decreaseIndentation() {
        if (this.indentationLevel > this.minimumIndentationLevel) {
            --this.indentationLevel;
        }
    }

    private void increaseIndentation() {
        ++this.indentationLevel;
    }

    public void setMinimumIndentation(int minimumIndentation) {
        this.minimumIndentationLevel = minimumIndentation;
        this.indentationLevel = Math.max(this.indentationLevel, this.minimumIndentationLevel);
    }

    public void forceIndentation(int indentation) {
        this.indentationLevel = indentation;
    }

    public String generateScript() {
        return this.scriptBuilder.toString();
    }

    public int hashCode() {
        return this.generateScript().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !ScriptWriter.class.equals(obj.getClass())) {
            return false;
        }
        ScriptWriter otherWriter = (ScriptWriter)obj;
        return this.generateScript().equals(otherWriter.generateScript());
    }

    public String toString() {
        return this.generateScript();
    }

    public void writeChildren(Iterable<?> children) {
        if (children == null) {
            return;
        }
        for (ControllerInterfaceProgramNode child : CollectionUtils.filter(children, ControllerInterfaceProgramNode.class)) {
            child.generateScriptCode(this);
        }
    }

    public void assignPinToValue(String value) {
        this.writeText(value);
    }

    public void writeNode(ControllerInterfaceProgramNode node) {
        if (node != null) {
            node.generateScriptCode(this);
        }
    }

    public static enum PopupLevel {
        ERROR{

            @Override
            public String generateText(String popupMessage, String title, boolean isBlocking) {
                return "popup(\"" + popupMessage + "\", \"" + title + "\", False, True, blocking=" + PopupLevel.getBoolean(isBlocking) + ")";
            }
        }
        ,
        WARNING{

            @Override
            public String generateText(String popupMessage, String title, boolean isBlocking) {
                return "popup(\"" + popupMessage + "\", \"" + title + "\", True, False, blocking=" + PopupLevel.getBoolean(isBlocking) + ")";
            }
        }
        ,
        INFO{

            @Override
            public String generateText(String popupMessage, String title, boolean isBlocking) {
                return "popup(\"" + popupMessage + "\", \"" + title + "\", False, False, blocking=" + PopupLevel.getBoolean(isBlocking) + ")";
            }
        };


        private static String getBoolean(boolean isBlocking) {
            return isBlocking ? "True" : "False";
        }

        public abstract String generateText(String var1, String var2, boolean var3);
    }

    public static class ScriptPosition {
        private int line;
        private int column;

        public ScriptPosition(int line) {
            this.line = line;
            this.column = 1;
        }

        public ScriptPosition(int line, int column) {
            this.line = line;
            this.column = column;
        }

        ScriptPosition(ScriptPosition scriptPosition) {
            this.line = scriptPosition.line;
            this.column = scriptPosition.column;
        }

        public static ScriptPosition getEndPostion(String string) {
            int lines = StringUtils.numberOfOccurances((String)"\n", (String)string);
            return new ScriptPosition(lines);
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equal(ScriptPosition scriptPosition) {
            return this.line == scriptPosition.line && this.column == scriptPosition.column;
        }

        public boolean less(ScriptPosition scriptPosition) {
            return this.line < scriptPosition.line || this.line == scriptPosition.line && this.column < scriptPosition.column;
        }

        public boolean lessEqual(ScriptPosition scriptPosition) {
            return this.less(scriptPosition) || this.equal(scriptPosition);
        }

        public boolean larger(ScriptPosition scriptPosition) {
            return this.line > scriptPosition.line || this.line == scriptPosition.line && this.column > scriptPosition.column;
        }

        public ScriptPosition add(ScriptPosition offset) {
            return new ScriptPosition(this.line + offset.line, this.column + offset.column);
        }

        public boolean largerEqual(ScriptPosition scriptPosition) {
            return this.larger(scriptPosition) || this.equal(scriptPosition);
        }

        public String toString() {
            return "(" + this.line + ", " + this.column + ")";
        }

        public int index(String string) {
            if (this.line == 1) {
                return 0;
            }
            int index = StringUtils.getIndexOfNthOccurance((int)(this.line - 1), (String)"\n", (String)string) + 1;
            return index == -1 ? string.length() : index;
        }
    }
}

